/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.List;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.element.settings.SettingDirection;
import jobicade.betterhud.element.settings.SettingPercentage;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.settings.SettingSlider;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Compass
extends HudElement {
    private static final String[] DIRECTIONS = new String[]{"S", "E", "N", "W"};
    private SettingChoose mode;
    private SettingChoose requireItem;
    private SettingSlider directionScaling;
    private SettingBoolean showNotches;
    private static final int[] notchX = new int[9];

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.NORTH);
        this.directionScaling.set(0.5);
        this.showNotches.set(true);
        this.requireItem.setIndex(0);
        this.settings.priority.set(-3);
    }

    public Compass() {
        super("compass", new SettingPosition(DirectionOptions.TOP_BOTTOM, DirectionOptions.NORTH_SOUTH));
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.mode = new SettingChoose("mode", "visual", "text");
        settings.add(this.mode);
        settings.add(new Legend("misc"));
        this.directionScaling = new SettingPercentage("letterScale");
        settings.add(this.directionScaling);
        this.showNotches = new SettingBoolean("showNotches").setValuePrefix("betterHud.value.visible");
        settings.add(this.showNotches);
        this.requireItem = new SettingChoose("requireItem", "disabled", "inventory", "hand");
        settings.add(this.requireItem);
    }

    private void drawBackground(Rect bounds) {
        GlUtil.drawRect(bounds, new Color(170, 0, 0, 0));
        GlUtil.drawRect(bounds.grow(-50, 0, -50, 0), new Color(85, 85, 85, 85));
        Direction alignment = this.position.getContentAlignment();
        Rect smallRect = bounds.grow(2);
        Rect largeNotch = new Rect(1, 7);
        Rect smallNotch = new Rect(1, 6);
        Rect largeRect = bounds.grow(0, 3, 0, 3);
        if (this.showNotches.get().booleanValue()) {
            for (int loc : notchX) {
                Rect notchTemp = smallNotch.anchor(smallRect, alignment);
                GlUtil.drawRect(notchTemp.translate(loc, 0), Color.WHITE);
                GlUtil.drawRect(notchTemp.translate(-loc, 0), Color.WHITE);
            }
        }
        GlUtil.drawRect(largeNotch.anchor(largeRect, alignment.withCol(0)), Color.RED);
        GlUtil.drawRect(largeNotch.anchor(largeRect, alignment.withCol(1)), Color.RED);
        GlUtil.drawRect(largeNotch.anchor(largeRect, alignment.withCol(2)), Color.RED);
    }

    private void drawDirections(Rect bounds) {
        float angle = (float)Math.toRadians(Minecraft.func_71410_x().field_71439_g.field_70177_z);
        float radius = bounds.getWidth() / 2 + 5;
        boolean bottom = this.position.getContentAlignment() == Direction.SOUTH;
        Point origin = bounds.grow(-2).getAnchor(this.position.getContentAlignment());
        for (int i = 0; i < 4; ++i) {
            double cos = Math.cos(angle);
            Point letter = origin.add(-((int)(Math.sin(angle) * (double)radius)), 0);
            double scale = 1.0 + this.directionScaling.get() * cos * 2.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)letter.getX(), (float)letter.getY(), (float)0.0f);
            GlUtil.scale((float)scale);
            Color color = i == 0 ? Color.BLUE : (i == 2 ? Color.RED : Color.WHITE);
            color = color.withAlpha((int)((cos + 1.0) / 2.0 * 255.0));
            if (color.getAlpha() > 3) {
                GlUtil.drawString(DIRECTIONS[i], Point.zero(), bottom ? Direction.SOUTH : Direction.NORTH, color);
            }
            GlStateManager.func_179121_F();
            angle = (float)((double)angle + 1.5707963267948966);
        }
    }

    @Override
    public boolean shouldRender(Event event) {
        if (!super.shouldRender(event)) {
            return false;
        }
        switch (this.requireItem.getIndex()) {
            case 1: {
                return Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70431_c(new ItemStack(Items.field_151111_aL));
            }
            case 2: {
                return Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == Items.field_151111_aL || Minecraft.func_71410_x().field_71439_g.func_184592_cb().func_77973_b() == Items.field_151111_aL;
            }
        }
        return true;
    }

    public String getText() {
        Direction direction;
        String coord;
        EnumFacing enumfacing = Minecraft.func_71410_x().field_71439_g.func_174811_aO();
        switch (enumfacing) {
            case NORTH: {
                coord = "-Z";
                direction = Direction.NORTH;
                break;
            }
            case SOUTH: {
                coord = "+Z";
                direction = Direction.SOUTH;
                break;
            }
            case WEST: {
                coord = "-X";
                direction = Direction.WEST;
                break;
            }
            case EAST: {
                coord = "+X";
                direction = Direction.EAST;
                break;
            }
            default: {
                return "?";
            }
        }
        return I18n.func_135052_a((String)"betterHud.hud.facing", (Object[])new Object[]{SettingDirection.localizeDirection(direction), coord});
    }

    @Override
    public Rect render(Event event) {
        Rect bounds;
        if (this.mode.getIndex() == 0) {
            bounds = this.position.applyTo(new Rect(180, 12));
            Minecraft.func_71410_x().field_71424_I.func_76320_a("background");
            this.drawBackground(bounds);
            Minecraft.func_71410_x().field_71424_I.func_76318_c("text");
            this.drawDirections(bounds);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        } else {
            String text = this.getText();
            bounds = this.position.applyTo(new Rect(GlUtil.getStringSize(text)));
            Minecraft.func_71410_x().field_71424_I.func_76320_a("text");
            GlUtil.drawString(text, bounds.getPosition(), Direction.NORTH_WEST, Color.WHITE);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
        return bounds;
    }

    static {
        int x = 0;
        double i = 0.1;
        while (i <= 0.9) {
            Compass.notchX[x] = (int)(Math.asin(i) / Math.PI * 180.0);
            i += 0.1;
            ++x;
        }
    }
}

