/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.ArrayList;
import java.util.List;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.settings.SettingWarnings;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.util.MathUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public abstract class EquipmentDisplay
extends HudElement {
    private SettingBoolean showName;
    private SettingBoolean showDurability;
    private SettingWarnings warnings;
    private SettingChoose durabilityMode;
    private SettingBoolean showUndamaged;

    protected EquipmentDisplay(String name, SettingPosition position) {
        super(name, position);
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.showName = new SettingBoolean("showName");
        settings.add(this.showName);
        this.showDurability = new SettingBoolean("showDurability", Direction.WEST);
        settings.add(this.showDurability);
        this.durabilityMode = new SettingChoose("durabilityFormat", Direction.EAST, new String[]{"points", "percentage"}){

            @Override
            public boolean enabled() {
                return EquipmentDisplay.this.showDurability.get();
            }
        };
        settings.add(this.durabilityMode);
        this.showUndamaged = new SettingBoolean("showUndamaged"){

            @Override
            public boolean enabled() {
                return EquipmentDisplay.this.showDurability.get();
            }
        }.setValuePrefix("betterHud.value.visible");
        settings.add(this.showUndamaged);
        this.warnings = new SettingWarnings("damageWarning");
        settings.add(this.warnings);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.showName.set(true);
        this.showDurability.set(true);
        this.durabilityMode.setIndex(0);
        this.showUndamaged.set(true);
        this.warnings.set(new Double[]{0.45, 0.25, 0.1});
    }

    protected boolean hasText() {
        return this.showName.get() != false || this.showDurability.get() != false;
    }

    protected boolean showDurability(ItemStack stack) {
        return this.showDurability.get() != false && (this.showUndamaged.get() != false ? stack.func_77984_f() : stack.func_77951_h());
    }

    protected String getText(ItemStack stack) {
        int count;
        if (!this.hasText() || stack.func_190926_b()) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (this.showName.get().booleanValue()) {
            parts.add(stack.func_82833_r());
        }
        int maxDurability = stack.func_77958_k();
        int durability = maxDurability - stack.func_77952_i();
        float value = (float)durability / (float)maxDurability;
        if (this.showDurability(stack)) {
            if (this.durabilityMode.getIndex() == 1) {
                parts.add(MathUtil.formatToPlaces(value * 100.0f, 1) + "%");
            } else {
                parts.add(durability + "/" + maxDurability);
            }
        }
        String text = String.join((CharSequence)" - ", parts);
        if (stack.func_77984_f() && (count = this.warnings.getWarning(value)) > 0) {
            text = text + ' ' + I18n.func_135052_a((String)("betterHud.setting.warning." + count), (Object[])new Object[0]);
        }
        return text;
    }
}

