/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.List;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingPercentage;
import jobicade.betterhud.element.settings.SettingSlider;
import jobicade.betterhud.geom.Rect;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GlobalSettings
extends HudElement {
    private SettingPercentage billboardScale;
    private SettingSlider billboardDistance;
    private SettingBoolean hideOnDebug;
    private SettingBoolean debugMode;

    public GlobalSettings() {
        super("global");
        ELEMENTS.remove(this);
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.billboardScale = new SettingPercentage("billboardScale");
        settings.add(this.billboardScale);
        this.billboardDistance = new SettingSlider("rayDistance", 5.0, 200.0).setUnlocalizedValue("betterHud.hud.meters");
        settings.add(this.billboardDistance);
        this.hideOnDebug = new SettingBoolean("hideOnDebug");
        settings.add(this.hideOnDebug);
        this.debugMode = new SettingBoolean("debugMode");
        settings.add(this.debugMode);
    }

    public float getBillboardScale() {
        return this.billboardScale.get().floatValue();
    }

    public float getBillboardDistance() {
        return this.billboardDistance.get().floatValue();
    }

    public boolean hideOnDebug() {
        return this.hideOnDebug.get();
    }

    public boolean isDebugMode() {
        return this.debugMode.get();
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.billboardScale.set(0.5);
        this.billboardDistance.set(100.0);
        this.hideOnDebug.set(true);
    }

    @Override
    public boolean shouldRender(Event event) {
        return false;
    }

    @Override
    public Rect render(Event event) {
        return null;
    }
}

