/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.List;
import jobicade.betterhud.element.EquipmentDisplay;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class HandBar
extends EquipmentDisplay {
    private SettingBoolean showItem;
    private SettingBoolean offHand;
    private SettingBoolean showBars;
    private SettingBoolean showNonTools;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.SOUTH);
        this.showItem.set(true);
        this.showBars.set(true);
        this.offHand.set(false);
        this.settings.priority.set(100);
    }

    public HandBar() {
        super("handBar", new SettingPosition(DirectionOptions.BAR, DirectionOptions.NORTH_SOUTH));
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        settings.add(new Legend("misc"));
        this.showItem = new SettingBoolean("showItem").setValuePrefix("betterHud.value.visible");
        settings.add(this.showItem);
        this.showBars = new SettingBoolean("bars");
        settings.add(this.showBars);
        this.offHand = new SettingBoolean("offhand");
        settings.add(this.offHand);
        this.showNonTools = new SettingBoolean("showNonTools").setValuePrefix("betterHud.value.nonTools");
        settings.add(this.showNonTools);
    }

    public void renderBar(ItemStack stack, int x, int y) {
        boolean isTool = stack.func_77984_f();
        if (stack == null || !this.showNonTools.get().booleanValue() && !isTool) {
            return;
        }
        String text = this.getText(stack);
        int width = 0;
        if (this.showItem.get().booleanValue()) {
            width += 21;
        }
        if (text != null) {
            width += Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        }
        if (this.showItem.get().booleanValue()) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a("items");
            GlUtil.renderSingleItem(stack, x + 90 - width / 2, y);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
        if (text != null) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a("text");
            GlUtil.drawString(text, new Point(x + 90 - width / 2 + (this.showItem.get() != false ? 21 : 0), y + 4), Direction.NORTH_WEST, Color.WHITE);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
        if (isTool && this.showBars.get().booleanValue()) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a("bars");
            GlUtil.drawDamageBar(new Rect(x, y + 16, 180, 2), stack, false);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    @Override
    public Rect render(Event event) {
        Rect bounds = this.position.applyTo(new Rect(180, this.offHand.get() != false ? 41 : 18));
        this.renderBar(Minecraft.func_71410_x().field_71439_g.func_184614_ca(), bounds.getX(), bounds.getBottom() - 18);
        if (this.offHand.get().booleanValue()) {
            this.renderBar(Minecraft.func_71410_x().field_71439_g.func_184592_cb(), bounds.getX(), bounds.getY());
        }
        return bounds;
    }
}

