/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.List;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import jobicade.betterhud.util.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.eventhandler.Event;

public class HealIndicator
extends HudElement {
    private SettingChoose mode;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.NORTH_WEST);
        this.mode.setIndex(1);
    }

    public HealIndicator() {
        super("healIndicator");
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        settings.add(new Legend("misc"));
        this.mode = new SettingChoose(2);
        settings.add(this.mode);
    }

    @Override
    public Rect render(Event event) {
        Rect bounds;
        String healIndicator = I18n.func_135052_a((String)"betterHud.hud.healIndicator", (Object[])new Object[0]);
        Rect rect = bounds = this.mode.getIndex() == 0 ? new Rect(Minecraft.func_71410_x().field_71466_p.func_78256_a(healIndicator), Minecraft.func_71410_x().field_71466_p.field_78288_b) : new Rect(9, 9);
        if (this.position.isCustom()) {
            bounds = this.position.applyTo(bounds);
        } else {
            Direction side = HudElement.HEALTH.getIndicatorSide();
            bounds = bounds.align(HudElement.HEALTH.getLastBounds().grow(5, 0, 5, 0).getAnchor(side), side.mirrorCol());
        }
        if (this.mode.getIndex() == 0) {
            GlUtil.drawString(healIndicator, bounds.getPosition(), Direction.NORTH_WEST, Color.GREEN);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.HUD_ICONS);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(bounds.getX(), bounds.getY(), 0, 80, 9, 9);
        }
        return bounds;
    }

    @Override
    public boolean shouldRender(Event event) {
        return super.shouldRender(event) && Minecraft.func_71410_x().field_71442_b.func_78763_f() && Minecraft.func_71410_x().field_71441_e.func_82736_K().func_82766_b("naturalRegeneration") && Minecraft.func_71410_x().field_71439_g.func_71024_bL().func_75116_a() >= 18 && Minecraft.func_71410_x().field_71439_g.func_70996_bM();
    }
}

