/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.ArmorBars;
import jobicade.betterhud.element.ArrowCount;
import jobicade.betterhud.element.BlockViewer;
import jobicade.betterhud.element.Compass;
import jobicade.betterhud.element.ExperienceInfo;
import jobicade.betterhud.element.GlobalSettings;
import jobicade.betterhud.element.HandBar;
import jobicade.betterhud.element.HealIndicator;
import jobicade.betterhud.element.PickupCount;
import jobicade.betterhud.element.SignReader;
import jobicade.betterhud.element.entityinfo.HorseInfo;
import jobicade.betterhud.element.entityinfo.MobInfo;
import jobicade.betterhud.element.entityinfo.PlayerInfo;
import jobicade.betterhud.element.particles.BloodSplatters;
import jobicade.betterhud.element.particles.WaterDrops;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.RootSetting;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.text.BiomeName;
import jobicade.betterhud.element.text.Connection;
import jobicade.betterhud.element.text.Coordinates;
import jobicade.betterhud.element.text.CpsCount;
import jobicade.betterhud.element.text.Distance;
import jobicade.betterhud.element.text.FpsCount;
import jobicade.betterhud.element.text.FullInvIndicator;
import jobicade.betterhud.element.text.GameClock;
import jobicade.betterhud.element.text.LightLevel;
import jobicade.betterhud.element.text.Saturation;
import jobicade.betterhud.element.text.SystemClock;
import jobicade.betterhud.element.vanilla.AirBar;
import jobicade.betterhud.element.vanilla.ArmorBar;
import jobicade.betterhud.element.vanilla.Crosshair;
import jobicade.betterhud.element.vanilla.Experience;
import jobicade.betterhud.element.vanilla.FoodBar;
import jobicade.betterhud.element.vanilla.HealthBar;
import jobicade.betterhud.element.vanilla.HelmetOverlay;
import jobicade.betterhud.element.vanilla.Hotbar;
import jobicade.betterhud.element.vanilla.JumpBar;
import jobicade.betterhud.element.vanilla.Offhand;
import jobicade.betterhud.element.vanilla.PortalOverlay;
import jobicade.betterhud.element.vanilla.PotionBar;
import jobicade.betterhud.element.vanilla.RidingHealth;
import jobicade.betterhud.element.vanilla.Sidebar;
import jobicade.betterhud.element.vanilla.Vignette;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.util.IGetSet;
import jobicade.betterhud.util.SortField;
import jobicade.betterhud.util.Sorter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.versioning.Restriction;
import net.minecraftforge.fml.common.versioning.VersionRange;

public abstract class HudElement
implements IGetSet.IBoolean {
    public static final List<HudElement> ELEMENTS = new ArrayList<HudElement>();
    public static final ArmorBars ARMOR_BARS = new ArmorBars();
    public static final ArrowCount ARROW_COUNT = new ArrowCount();
    public static final BiomeName BIOME_NAME = new BiomeName();
    public static final BlockViewer BLOCK_VIEWER = new BlockViewer();
    public static final BloodSplatters BLOOD_SPLATTERS = new BloodSplatters();
    public static final Compass COMPASS = new Compass();
    public static final Connection CONNECTION = new Connection();
    public static final Coordinates COORDINATES = new Coordinates();
    public static final CpsCount CPS = new CpsCount();
    public static final Distance DISTANCE = new Distance();
    public static final ExperienceInfo EXPERIENCE_INFO = new ExperienceInfo();
    public static final FpsCount FPS = new FpsCount();
    public static final FullInvIndicator FULL_INV = new FullInvIndicator();
    public static final GameClock CLOCK = new GameClock();
    public static final GlobalSettings GLOBAL = new GlobalSettings();
    public static final HandBar HOLDING = new HandBar();
    public static final HealIndicator HEAL = new HealIndicator();
    public static final HorseInfo HORSE_INFO = new HorseInfo();
    public static final LightLevel LIGHT_LEVEL = new LightLevel();
    public static final MobInfo MOB_INFO = new MobInfo();
    public static final PickupCount PICKUP = new PickupCount();
    public static final PlayerInfo PLAYER_INFO = new PlayerInfo();
    public static final Saturation SATURATION = new Saturation();
    public static final SignReader SIGN_READER = new SignReader();
    public static final SystemClock SYSTEM_CLOCK = new SystemClock();
    public static final WaterDrops WATER_DROPS = new WaterDrops();
    public static final AirBar AIR_BAR = new AirBar();
    public static final ArmorBar ARMOR_BAR = new ArmorBar();
    public static final Crosshair CROSSHAIR = new Crosshair();
    public static final Experience EXPERIENCE = new Experience();
    public static final FoodBar FOOD_BAR = new FoodBar();
    public static final HealthBar HEALTH = new HealthBar();
    public static final HelmetOverlay HELMET_OVERLAY = new HelmetOverlay();
    public static final Hotbar HOTBAR = new Hotbar();
    public static final JumpBar JUMP_BAR = new JumpBar();
    public static final Offhand OFFHAND = new Offhand();
    public static final PortalOverlay PORTAL = new PortalOverlay();
    public static final PotionBar POTION_BAR = new PotionBar();
    public static final RidingHealth MOUNT = new RidingHealth();
    public static final Sidebar SIDEBAR = new Sidebar();
    public static final Vignette VIGNETTE = new Vignette();
    public static final Sorter<HudElement> SORTER = new Sorter<HudElement>(ELEMENTS);
    public final RootSetting settings;
    protected final SettingPosition position;
    public final int id;
    public final String name;
    private Rect lastBounds = Rect.empty();

    @Override
    public Boolean get() {
        return this.settings.get();
    }

    @Override
    public void set(Boolean value) {
        this.settings.set(value);
    }

    public boolean isEnabledAndSupported() {
        return this.settings.get() != false && this.isSupportedByServer();
    }

    protected HudElement(String name) {
        this(name, new SettingPosition(DirectionOptions.NONE, DirectionOptions.NONE));
    }

    protected HudElement(String name, SettingPosition position) {
        this.name = name;
        this.position = position;
        ArrayList rootSettings = new ArrayList();
        this.addSettings(rootSettings);
        this.settings = new RootSetting(this, rootSettings);
        this.id = ELEMENTS.size();
        ELEMENTS.add(this);
    }

    protected void addSettings(List<Setting<?>> settings) {
        if (this.position.getDirectionOptions() != DirectionOptions.NONE || this.position.getContentOptions() != DirectionOptions.NONE) {
            settings.add(this.position);
        }
    }

    public VersionRange getServerDependency() {
        return VersionRange.newRange(null, Arrays.asList(Restriction.EVERYTHING));
    }

    public boolean isSupportedByServer() {
        return this.getServerDependency().containsVersion(BetterHud.getServerVersion());
    }

    public final String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public final String getUnlocalizedName() {
        return "betterHud.element." + this.name;
    }

    public boolean shouldRender(Event event) {
        return event instanceof RenderGameOverlayEvent;
    }

    protected abstract Rect render(Event var1);

    public final void tryRender(Event event) {
        if (this.shouldRender(event) && this.isEnabledAndSupported()) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a(this.name);
            this.lastBounds = this.render(event);
            if (this.lastBounds == null) {
                this.lastBounds = Rect.empty();
            }
            this.postRender(event);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    protected void postRender(Event event) {
    }

    public static void renderAll(Event event) {
        for (HudElement element : SORTER.getSortedData(SortType.PRIORITY)) {
            element.tryRender(event);
        }
    }

    public Rect getLastBounds() {
        return this.lastBounds;
    }

    public static void initAll(FMLInitializationEvent event) {
        for (HudElement element : ELEMENTS) {
            element.init(event);
        }
    }

    public void init(FMLInitializationEvent event) {
    }

    public static void loadAllDefaults() {
        GLOBAL.loadDefaults();
        for (HudElement element : ELEMENTS) {
            element.loadDefaults();
        }
        HudElement.normalizePriority();
    }

    public static void normalizePriority() {
        SORTER.markDirty(SortType.PRIORITY);
        List<HudElement> prioritySort = SORTER.getSortedData(SortType.PRIORITY);
        for (int i = 0; i < prioritySort.size(); ++i) {
            prioritySort.get((int)i).settings.priority.set(i);
        }
    }

    protected void loadDefaults() {
        this.set(true);
        this.settings.priority.set(0);
    }

    public static float getPartialTicks(Event event) {
        if (event instanceof RenderGameOverlayEvent) {
            return ((RenderGameOverlayEvent)event).getPartialTicks();
        }
        if (event instanceof RenderWorldLastEvent) {
            return ((RenderWorldLastEvent)event).getPartialTicks();
        }
        return 0.0f;
    }

    public static enum SortType implements SortField<HudElement>
    {
        ALPHABETICAL("alphabetical", false){

            @Override
            public int compare(HudElement a, HudElement b) {
                return a.getLocalizedName().compareTo(b.getLocalizedName());
            }
        }
        ,
        ENABLED("enabled", false){

            @Override
            public int compare(HudElement a, HudElement b) {
                int compare = b.settings.get().compareTo(a.settings.get());
                return compare != 0 ? compare : ALPHABETICAL.compare(a, b);
            }
        }
        ,
        PRIORITY("priority", false){

            @Override
            public int compare(HudElement a, HudElement b) {
                int compare = ((Integer)a.settings.priority.get()).compareTo((Integer)b.settings.priority.get());
                return compare != 0 ? compare : ALPHABETICAL.compare(a, b);
            }
        };

        private final String unlocalizedName;
        private final boolean inverted;

        private SortType(String unlocalizedName, boolean inverted) {
            this.unlocalizedName = "betterHud.menu." + unlocalizedName;
            this.inverted = inverted;
        }

        @Override
        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        @Override
        public boolean isInverted() {
            return this.inverted;
        }
    }
}

