/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.entityinfo;

import java.util.ArrayList;
import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.entityinfo.EntityInfo;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.events.RenderMobInfoEvent;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.util.GlUtil;
import jobicade.betterhud.util.MathUtil;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraftforge.fml.common.eventhandler.Event;

public class HorseInfo
extends EntityInfo {
    private SettingBoolean jump;
    private SettingBoolean speed;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.jump.set(true);
        this.speed.set(true);
    }

    public HorseInfo() {
        super("horseInfo");
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.jump = new SettingBoolean("jump");
        settings.add(this.jump);
        this.speed = new SettingBoolean("speed");
        settings.add(this.speed);
    }

    @Override
    public boolean shouldRender(Event event) {
        return super.shouldRender(event) && ((RenderMobInfoEvent)event).getEntity() instanceof EntityHorse;
    }

    @Override
    public Rect render(Event event) {
        ArrayList<Label> infoParts = new ArrayList<Label>();
        EntityHorse entity = (EntityHorse)((RenderMobInfoEvent)event).getEntity();
        if (this.jump.get().booleanValue()) {
            infoParts.add(new Label(this.jump.getLocalizedName() + ": " + MathUtil.formatToPlaces(this.getJumpHeight(entity), 3) + "m"));
        }
        if (this.speed.get().booleanValue()) {
            infoParts.add(new Label(this.speed.getLocalizedName() + ": " + MathUtil.formatToPlaces(this.getSpeed(entity), 3) + "m/s"));
        }
        Grid grid = new Grid(new Point(1, infoParts.size()), infoParts).setGutter(new Point(2, 2));
        Rect bounds = new Rect(grid.getPreferredSize().add(10, 10));
        bounds = BetterHud.MANAGER.position(Direction.SOUTH, bounds);
        GlUtil.drawRect(bounds, Color.TRANSLUCENT);
        grid.setBounds(new Rect(grid.getPreferredSize()).anchor(bounds, Direction.CENTER)).render();
        return null;
    }

    public double getJumpHeight(EntityHorse horse) {
        double jumpStrength = horse.func_110215_cj();
        return jumpStrength * (jumpStrength * (jumpStrength * -0.1817584952 + 3.689713992) + 2.128599134) - 0.343930367;
    }

    public double getSpeed(EntityHorse horse) {
        return horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 43.17037;
    }
}

