/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.entityinfo;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.entityinfo.EntityInfo;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingSlider;
import jobicade.betterhud.events.RenderMobInfoEvent;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import jobicade.betterhud.util.MathUtil;
import jobicade.betterhud.util.bars.StatBarHealth;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MobInfo
extends EntityInfo {
    private final StatBarHealth bar = new StatBarHealth();
    private SettingSlider compress;

    public MobInfo() {
        super("mobInfo");
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.compress = new SettingSlider("compress", 0.0, 200.0, 20.0){

            @Override
            public String getDisplayValue(double value) {
                if (value == 0.0) {
                    return I18n.func_135052_a((String)"betterHud.value.never", (Object[])new Object[0]);
                }
                return super.getDisplayValue(value);
            }
        };
        settings.add(this.compress);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.compress.set(40.0);
        this.settings.priority.set(-1);
    }

    @Override
    public Rect render(Event event) {
        EntityLivingBase entity = ((RenderMobInfoEvent)event).getEntity();
        this.bar.setHost(entity);
        this.bar.setCompressThreshold(this.compress.getInt());
        int health = MathUtil.getHealthForDisplay(entity.func_110143_aJ());
        int maxHealth = MathUtil.getHealthForDisplay(entity.func_110138_aP());
        String text = String.format("%s %s(%d/%d)", entity.func_70005_c_(), ChatFormatting.GRAY, health, maxHealth);
        Point size = GlUtil.getStringSize(text);
        Size barSize = this.bar.getPreferredSize();
        size = barSize.getX() > size.getX() ? new Point(barSize.getX(), size.getY() + barSize.getY()) : size.add(0, barSize.getY());
        Rect bounds = BetterHud.MANAGER.position(Direction.SOUTH, new Rect(size).grow(5));
        GlUtil.drawRect(bounds, Color.TRANSLUCENT);
        bounds = bounds.grow(-5);
        GlUtil.drawString(text, bounds.getPosition(), Direction.NORTH_WEST, Color.WHITE);
        Rect barRect = new Rect(barSize).anchor(bounds, Direction.SOUTH_WEST);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        this.bar.setBounds(barRect).render();
        return null;
    }
}

