/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.entityinfo;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.entityinfo.EntityInfo;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingSlider;
import jobicade.betterhud.events.RenderMobInfoEvent;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.util.GlUtil;
import jobicade.betterhud.util.bars.StatBar;
import jobicade.betterhud.util.bars.StatBarArmor;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlayerInfo
extends EntityInfo {
    private StatBar<? super EntityPlayer> bar = new StatBarArmor();
    private SettingSlider tooltipLines;

    public PlayerInfo() {
        super("playerInfo");
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.tooltipLines = new SettingSlider("tooltipLines", -1.0, 10.0, 1.0){

            @Override
            public String getDisplayValue(double scaledValue) {
                if (scaledValue == -1.0) {
                    return I18n.func_135052_a((String)"betterHud.value.unlimited", (Object[])new Object[0]);
                }
                return super.getDisplayValue(scaledValue);
            }
        };
        settings.add(this.tooltipLines);
    }

    @Override
    public boolean shouldRender(Event event) {
        return super.shouldRender(event) && ((RenderMobInfoEvent)event).getEntity() instanceof EntityPlayer;
    }

    @Override
    public Rect render(Event event) {
        EntityPlayer player = (EntityPlayer)((RenderMobInfoEvent)event).getEntity();
        this.bar.setHost((EntityPlayer)player);
        List<String> tooltip = new ArrayList<String>();
        ItemStack held = player.func_184614_ca();
        if (!held.func_190926_b()) {
            tooltip.add(I18n.func_135052_a((String)"betterHud.hud.holding", (Object[])new Object[]{this.getStackName(held)}));
            this.getEnchantmentLines(held, tooltip);
            int lines = this.tooltipLines.getInt();
            if (lines != -1 && lines < tooltip.size()) {
                tooltip = tooltip.subList(0, lines);
            }
        }
        List tooltipLabels = tooltip.stream().map(Label::new).collect(Collectors.toList());
        Grid grid = new Grid(new Point(1, tooltip.size()), tooltipLabels).setCellAlignment(Direction.WEST).setGutter(new Point(2, 2));
        Rect bounds = new Rect(grid.getPreferredSize().add(10, 10));
        if (this.bar.shouldRender()) {
            bounds = bounds.grow(0, 0, 0, this.bar.getPreferredSize().getY() + 2);
        }
        bounds = BetterHud.MANAGER.position(Direction.SOUTH, bounds);
        GlUtil.drawRect(bounds, Color.TRANSLUCENT);
        Rect inner = bounds.grow(-5);
        grid.setBounds(new Rect(grid.getPreferredSize()).anchor(inner, Direction.NORTH_WEST)).render();
        if (this.bar.shouldRender()) {
            this.bar.setBounds(new Rect(this.bar.getPreferredSize()).anchor(inner, Direction.SOUTH_WEST)).render();
        }
        return null;
    }

    private String getStackName(ItemStack stack) {
        StringBuilder builder = new StringBuilder();
        if (stack.func_82837_s()) {
            builder.append(TextFormatting.ITALIC);
        }
        if (stack.func_77948_v()) {
            builder.append(TextFormatting.AQUA);
        } else {
            builder.append(TextFormatting.GRAY);
        }
        builder.append(stack.func_82833_r());
        return builder.toString();
    }

    private void getEnchantmentLines(ItemStack stack, List<String> dest) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Map.Entry enchantment : enchantments.entrySet()) {
            if (enchantment.getKey() == null || (Integer)enchantment.getValue() <= 0) continue;
            dest.add(ChatFormatting.GRAY + ((Enchantment)enchantment.getKey()).func_77316_c(((Integer)enchantment.getValue()).intValue()));
        }
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.tooltipLines.set(-1);
    }
}

