/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.particles;

import jobicade.betterhud.element.particles.Particle;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import jobicade.betterhud.util.MathUtil;
import jobicade.betterhud.util.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class ParticleBase
implements Particle {
    protected Point position;
    protected Rect texture;
    protected float opacity;
    protected float size;
    protected float rotation;

    protected ParticleBase(Point position, int iconIndex, float opacity, float size, float rotation) {
        this(position, new Rect(iconIndex % 16 * 16, iconIndex / 16 * 16, 16, 16), opacity, size, rotation);
    }

    protected ParticleBase(Point position, Rect texture, float opacity, float size, float rotation) {
        this.position = position;
        this.texture = texture;
        this.opacity = opacity;
        this.size = size;
        this.rotation = rotation;
    }

    public static ParticleBase createRandom() {
        Point position = MathUtil.randomPoint(Particle.getScreen());
        float opacity = MathUtil.randomRange(0.0f, 0.5f);
        float size = MathUtil.randomRange(2.0f, 6.0f);
        float rotation = MathUtil.randomRange(0.0f, 360.0f);
        int iconIndex = MathUtil.randomRange(0, 16);
        return new ParticleBase(position, iconIndex, opacity, size, rotation);
    }

    @Override
    public boolean shouldRender() {
        return !this.isDead();
    }

    @Override
    public void render(float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.HUD_ICONS);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.position.getX(), (float)this.position.getY(), (float)0.0f);
        GlStateManager.func_179114_b((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)this.size, (float)this.size, (float)1.0f);
        Color color = Color.WHITE.withAlpha(Math.round(this.opacity * 255.0f));
        Rect bounds = this.texture.align(Point.zero(), Direction.CENTER);
        GlUtil.drawRect(bounds, this.texture, color);
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    @Override
    public void tick() {
        this.opacity = (float)((double)this.opacity - 0.003);
    }

    @Override
    public boolean isDead() {
        return this.opacity <= 0.0f;
    }
}

