/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import jobicade.betterhud.config.HudConfig;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.gui.GuiElementSettings;
import jobicade.betterhud.util.IGetSet;
import jobicade.betterhud.util.ISaveLoad;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;

public abstract class Setting<T>
implements IGetSet<T>,
ISaveLoad {
    private Setting<?> parent = null;
    protected final List<Setting<?>> children = new ArrayList();
    public final String name;
    private Category category = Category.MISC;
    private String unlocalizedName;
    private Property property;
    private boolean hidden = false;
    private BooleanSupplier enableOn = () -> true;

    public Setting(String name) {
        this.name = name;
        if (name != null) {
            this.unlocalizedName = "betterHud.setting." + name;
        }
    }

    public Setting<T> setCategory(Category category) {
        this.category = category;
        return this;
    }

    public Category getCategory() {
        return this.category;
    }

    public Setting<T> setEnableOn(BooleanSupplier enableOn) {
        this.enableOn = enableOn;
        return this;
    }

    public Setting<T> setHidden() {
        this.hidden = true;
        return this;
    }

    protected void add(Setting<?> element) {
        this.children.add(element);
        element.parent = this;
    }

    protected void addAll(Iterable<Setting<?>> children) {
        for (Setting<?> child : children) {
            this.add(child);
        }
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public Setting<T> setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    protected boolean hasValue() {
        return this.name != null;
    }

    public boolean enabled() {
        return (this.parent == null || this.parent.enabled()) && this.enableOn.getAsBoolean();
    }

    protected final void bindConfig(HudConfig config, String category, StringBuilder path) {
        if (this.hasValue()) {
            this.property = this.getProperty(config, category, path.toString());
        }
        int length = path.length();
        for (Setting<?> child : this.children) {
            if (length > 0) {
                path.append('.');
            }
            path.append(child.name);
            child.bindConfig(config, category, path);
            path.setLength(length);
        }
    }

    public final void loadConfig() {
        if (this.property != null) {
            this.load(this.property.getString());
        }
        for (Setting<?> child : this.children) {
            child.loadConfig();
        }
    }

    public final void saveConfig() {
        if (this.property != null) {
            String save = this.save();
            if (this.property.getString() != save) {
                this.property.setValue(save);
            }
        }
        for (Setting<?> child : this.children) {
            child.saveConfig();
        }
    }

    protected Property getProperty(HudConfig config, String category, String path) {
        ConfigCategory configCategory = config.getCategory(category);
        Property property = null;
        String save = this.save();
        if (configCategory.containsKey(path)) {
            property = configCategory.get(path);
        }
        if (property == null || property.getType() != this.getPropertyType()) {
            property = new Property(path, this.save(), this.getPropertyType());
            property.setValue(save);
            configCategory.put(path, property);
        }
        property.setDefaultValue(save);
        return property;
    }

    protected Property.Type getPropertyType() {
        return Property.Type.STRING;
    }

    public Point getGuiParts(List<Gui> parts, Map<Gui, Setting<?>> callbacks, Point origin) {
        return Setting.getGuiParts(parts, callbacks, origin, this.children);
    }

    public static Point getGuiParts(List<Gui> parts, Map<Gui, Setting<?>> callbacks, Point origin, List<Setting<?>> settings) {
        if (!settings.isEmpty()) {
            for (Setting<?> setting : settings) {
                Point bottom;
                if (setting.hidden || (bottom = setting.getGuiParts(parts, callbacks, origin)) == null) continue;
                origin = bottom;
            }
        }
        return origin;
    }

    public void draw() {
        for (Setting<?> setting : this.children) {
            setting.draw();
        }
    }

    public abstract void actionPerformed(GuiElementSettings var1, GuiButton var2);

    public void updateGuiParts(Collection<Setting<?>> settings) {
        for (Setting<?> setting : this.children) {
            setting.updateGuiParts(settings);
        }
    }

    public static enum Category {
        MISC("misc"),
        POSITION("position");

        private final String unlocalizedName;

        private Category(String unlocalizedName) {
            this.unlocalizedName = unlocalizedName;
        }

        public String getUnlocalizedName() {
            return "betterHud.group." + this.unlocalizedName;
        }
    }
}

