/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.settings;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingAbsolutePosition;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.element.settings.SettingDirection;
import jobicade.betterhud.element.settings.SettingElement;
import jobicade.betterhud.element.settings.SettingLock;
import jobicade.betterhud.element.settings.SettingStub;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import net.minecraft.client.gui.Gui;

public class SettingPosition
extends SettingStub<Object> {
    private boolean edge = false;
    private int postSpacer = 5;
    private final SettingChoose mode;
    private final SettingDirection direction;
    private final SettingAbsolutePosition offset;
    private final SettingElement parent;
    private final SettingDirection anchor;
    private final SettingDirection alignment;
    private final SettingDirection contentAlignment;
    private final SettingLock lockAlignment;
    private final SettingLock lockContent;

    public DirectionOptions getDirectionOptions() {
        return this.direction.getOptions();
    }

    public DirectionOptions getContentOptions() {
        return this.contentAlignment.getOptions();
    }

    public SettingPosition(DirectionOptions directionOptions, DirectionOptions contentOptions) {
        this("position", directionOptions, contentOptions);
    }

    public SettingPosition(String name) {
        this(name, DirectionOptions.ALL, DirectionOptions.ALL);
    }

    public SettingPosition(String name, DirectionOptions directionOptions, DirectionOptions contentOptions) {
        super(name);
        this.add(new Legend("position"));
        this.mode = new SettingChoose("position", "preset", "custom");
        this.add(this.mode);
        this.direction = new SettingDirection("direction", Direction.WEST, directionOptions){

            @Override
            public boolean enabled() {
                return SettingPosition.this.mode.getIndex() == 0 && super.enabled();
            }
        }.setHorizontal();
        this.add(this.direction);
        this.parent = new SettingElement("parent", Direction.CENTER){

            @Override
            public boolean enabled() {
                return SettingPosition.this.mode.getIndex() == 1 && super.enabled();
            }
        };
        this.add(this.parent);
        this.anchor = new SettingDirection("anchor", Direction.WEST){

            @Override
            public boolean enabled() {
                return SettingPosition.this.mode.getIndex() == 1 && super.enabled();
            }
        };
        this.add(this.anchor);
        this.alignment = new SettingDirection("alignment", Direction.CENTER){

            @Override
            public boolean enabled() {
                return SettingPosition.this.mode.getIndex() == 1 && SettingPosition.this.lockAlignment.get() == false && super.enabled();
            }

            @Override
            public void updateGuiParts(Collection<Setting<?>> settings) {
                if (SettingPosition.this.lockAlignment.get().booleanValue()) {
                    this.set(SettingPosition.this.anchor.get());
                }
                super.updateGuiParts(settings);
            }
        };
        this.add(this.alignment);
        this.contentAlignment = new SettingDirection("contentAlignment", Direction.EAST, contentOptions){

            @Override
            public boolean enabled() {
                return SettingPosition.this.mode.getIndex() == 1 && SettingPosition.this.lockContent.get() == false && super.enabled();
            }

            @Override
            public void updateGuiParts(Collection<Setting<?>> settings) {
                if (SettingPosition.this.lockContent.get().booleanValue()) {
                    this.set(SettingPosition.this.alignment.get());
                }
                super.updateGuiParts(settings);
            }
        };
        this.add(this.contentAlignment);
        this.lockAlignment = new SettingLock("lockAlignment"){

            @Override
            public boolean enabled() {
                return SettingPosition.this.mode.getIndex() == 1 && super.enabled();
            }
        };
        this.add(this.lockAlignment);
        this.lockContent = new SettingLock("lockContent"){

            @Override
            public boolean enabled() {
                return SettingPosition.this.mode.getIndex() == 1 && super.enabled();
            }
        };
        this.add(this.lockContent);
        this.offset = new SettingAbsolutePosition("origin", this){

            @Override
            public boolean enabled() {
                return SettingPosition.this.mode.getIndex() == 1 && super.enabled();
            }
        };
        this.add(this.offset);
    }

    public boolean isDirection(Direction direction) {
        return !this.isCustom() && this.direction.get() == direction;
    }

    public boolean isCustom() {
        return this.mode.getIndex() == 1;
    }

    public Direction getDirection() {
        if (this.isCustom()) {
            throw new IllegalStateException("Position is not preset");
        }
        return this.direction.get();
    }

    public Rect getParent() {
        Rect bounds;
        if (!this.isCustom()) {
            throw new IllegalStateException("Position is not custom");
        }
        if (this.parent.get() != null && !(bounds = this.parent.get().getLastBounds()).isEmpty()) {
            return bounds;
        }
        return BetterHud.MANAGER.getScreen();
    }

    public Point getOffset() {
        if (!this.isCustom()) {
            throw new IllegalStateException("Position is not custom");
        }
        return this.offset.get();
    }

    public void setOffset(Point offset) {
        this.offset.set(offset);
    }

    public Direction getAnchor() {
        if (!this.isCustom()) {
            throw new IllegalStateException("Position is not custom");
        }
        return this.anchor.get();
    }

    public Direction getAlignment() {
        if (!this.isCustom()) {
            throw new IllegalStateException("Position is not custom");
        }
        return this.alignment.get();
    }

    public Direction getContentAlignment() {
        return this.isCustom() ? this.contentAlignment.get() : (Direction)((Object)this.contentAlignment.getOptions().apply(this.direction.get()));
    }

    public SettingPosition setEdge(boolean edge) {
        this.edge = edge;
        return this;
    }

    public SettingPosition setPostSpacer(int postSpacer) {
        this.postSpacer = postSpacer;
        return this;
    }

    public Rect applyTo(Rect bounds) {
        if (this.isCustom()) {
            return bounds.align(this.getParent().getAnchor(this.anchor.get()).add(this.offset.get()), this.alignment.get());
        }
        return BetterHud.MANAGER.position(this.direction.get(), bounds, this.edge, this.postSpacer);
    }

    public void setPreset(Direction direction) {
        this.mode.setIndex(0);
        this.direction.set(direction);
        this.offset.set(Point.zero());
        this.anchor.set(Direction.NORTH_WEST);
        this.alignment.set(Direction.NORTH_WEST);
        this.contentAlignment.set(Direction.NORTH_WEST);
        this.lockAlignment.set(true);
        this.lockContent.set(true);
    }

    public void setCustom(Direction anchor, Direction alignment, Direction contentAlignment, Point offset, boolean lockAlignment, boolean lockContent) {
        this.mode.setIndex(1);
        this.direction.set(Direction.NORTH_WEST);
        this.anchor.set(anchor);
        this.alignment.set(alignment);
        this.contentAlignment.set(contentAlignment);
        this.offset.set(offset);
        this.lockAlignment.set(lockAlignment);
        this.lockContent.set(lockContent);
    }

    @Override
    public Point getGuiParts(List<Gui> parts, Map<Gui, Setting<?>> callbacks, Point origin) {
        Point lockOffset = new Point(35, 173);
        this.lockAlignment.setRect(new Rect(20, 10).align(origin.add(lockOffset.withX(-lockOffset.getX())), Direction.EAST));
        this.lockContent.setRect(new Rect(20, 10).align(origin.add(lockOffset), Direction.WEST));
        return super.getGuiParts(parts, callbacks, origin);
    }
}

