/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.settings;

import java.util.List;
import java.util.Map;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingAlignable;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.gui.GuiElementSettings;
import jobicade.betterhud.gui.GuiSlider;
import jobicade.betterhud.util.ISlider;
import jobicade.betterhud.util.MathUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.Property;

public class SettingSlider
extends SettingAlignable<Double>
implements ISlider {
    protected GuiSlider slider;
    private final double min;
    private final double max;
    private final double interval;
    private int displayPlaces;
    private String unlocalizedValue;
    private double value;
    private double displayScale = 1.0;

    public SettingSlider(String name, double min, double max) {
        this(name, min, max, -1.0);
    }

    public SettingSlider(String name, double min, double max, double interval) {
        super(name, Direction.CENTER);
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.updateDisplayPlaces();
        this.set(this.getMinimum());
    }

    private void updateDisplayPlaces() {
        int places = this.interval != -1.0 && this.interval * this.displayScale == (double)((int)(this.interval * this.displayScale)) ? 0 : 1;
        this.setDisplayPlaces(places);
    }

    public SettingSlider setAlignment(Direction alignment) {
        this.alignment = alignment;
        return this;
    }

    public SettingSlider setDisplayScale(double displayScale) {
        this.displayScale = displayScale;
        this.updateDisplayPlaces();
        return this;
    }

    public SettingSlider setDisplayPlaces(int displayPlaces) {
        this.displayPlaces = displayPlaces;
        return this;
    }

    public SettingSlider setUnlocalizedValue(String unlocalizedValue) {
        this.unlocalizedValue = unlocalizedValue;
        return this;
    }

    @Override
    public String getDisplayString() {
        return I18n.func_135052_a((String)("betterHud.setting." + this.name), (Object[])new Object[0]) + ": " + this.getDisplayValue(this.get() * this.displayScale);
    }

    public String getDisplayValue(double scaledValue) {
        String displayValue = MathUtil.formatToPlaces(scaledValue, this.displayPlaces);
        if (this.unlocalizedValue != null) {
            displayValue = I18n.func_135052_a((String)this.unlocalizedValue, (Object[])new Object[]{displayValue});
        }
        return displayValue;
    }

    @Override
    public void getGuiParts(List<Gui> parts, Map<Gui, Setting<?>> callbacks, Rect bounds) {
        this.slider = new GuiSlider(0, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), this);
        parts.add((Gui)this.slider);
        callbacks.put((Gui)this.slider, this);
    }

    @Override
    public void actionPerformed(GuiElementSettings gui, GuiButton button) {
    }

    @Override
    public Double get() {
        return this.value;
    }

    public int getInt() {
        return this.get().intValue();
    }

    @Override
    public void set(Double value) {
        this.value = this.normalize(value);
        if (this.slider != null) {
            this.slider.updateDisplayString();
        }
    }

    @Override
    public void set(int value) {
        this.set(Double.valueOf(value));
    }

    @Override
    public String save() {
        return this.get().toString();
    }

    @Override
    public void load(String save) {
        this.set(Double.valueOf(save));
        if (this.slider != null) {
            this.slider.updateDisplayString();
        }
    }

    @Override
    protected Property.Type getPropertyType() {
        return Property.Type.DOUBLE;
    }

    @Override
    public Double getMinimum() {
        return this.min;
    }

    @Override
    public Double getMaximum() {
        return this.max;
    }

    @Override
    public Double getInterval() {
        return this.interval;
    }
}

