/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.settings;

import java.util.Collection;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingPercentage;
import jobicade.betterhud.element.settings.SettingSlider;
import jobicade.betterhud.element.settings.SettingStub;
import jobicade.betterhud.geom.Direction;
import net.minecraft.client.resources.I18n;

public class SettingWarnings
extends SettingStub<Double[]> {
    private final SettingSlider[] sliders;

    public SettingWarnings(String name) {
        this(name, 3);
    }

    public SettingWarnings(String name, int warnings) {
        super(name);
        this.add(new Legend("damageWarning"));
        this.sliders = new SettingSlider[warnings];
        for (int i = 0; i < this.sliders.length; ++i) {
            final int index = i;
            this.sliders[i] = new SettingPercentage("warning." + String.valueOf(i + 1)){

                @Override
                public String getDisplayValue(double value) {
                    SettingSlider next = this.next();
                    if (next == null || next.get() < this.get()) {
                        return super.getDisplayValue(value);
                    }
                    return I18n.func_135052_a((String)"betterHud.value.disabled", (Object[])new Object[0]);
                }

                @Override
                public void set(Double value) {
                    SettingSlider next = this.next();
                    super.set(next != null ? Math.max(value, next.get()) : value);
                    for (int i = index - 1; i >= 0; --i) {
                        SettingSlider slider = SettingWarnings.this.sliders[i];
                        if (slider == null) continue;
                        slider.set(Math.max(slider.get(), this.get()));
                    }
                }

                private SettingSlider next() {
                    return index == SettingWarnings.this.sliders.length - 1 ? null : SettingWarnings.this.sliders[index + 1];
                }

                @Override
                public void updateGuiParts(Collection<Setting<?>> settings) {
                    this.slider.updateDisplayString();
                }
            }.setAlignment((i & 1) == 1 ? Direction.EAST : Direction.WEST);
            this.add(this.sliders[i]);
        }
        if ((this.sliders.length & 1) == 1) {
            this.sliders[this.sliders.length - 1].setAlignment(Direction.CENTER);
        }
    }

    @Override
    public void set(Double[] values) {
        for (int i = 0; i < this.sliders.length; ++i) {
            if (!(values[i] >= 0.0)) continue;
            this.sliders[i].set(values[i]);
        }
    }

    @Override
    public Double[] get() {
        Double[] values = new Double[this.sliders.length];
        for (int i = 0; i < this.sliders.length; ++i) {
            values[i] = this.sliders[i].get();
        }
        return values;
    }

    public int getWarning(float value) {
        for (int i = this.sliders.length - 1; i >= 0; --i) {
            if (!((double)value <= this.sliders[i].get())) continue;
            return i + 1;
        }
        return 0;
    }
}

