/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.text;

import java.util.Arrays;
import java.util.List;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingSlider;
import jobicade.betterhud.element.text.TextElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.util.MathUtil;
import jobicade.betterhud.util.Tickable;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Mouse;

public class CpsCount
extends TextElement
implements Tickable {
    private SettingSlider timeoutMax;
    private SettingBoolean showBurst;
    private SettingBoolean remember;
    private int[] clickHistory = new int[10];
    private int i = 0;
    private int windowTotal = 0;
    private int burstTotal = 0;
    private int burstLength = 0;
    private int timeout = 0;
    private float cps = 0.0f;

    public CpsCount() {
        super("cps");
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        settings.add(new Legend("misc"));
        this.timeoutMax = new SettingSlider("timeout", 1.0, 10.0, 1.0).setUnlocalizedValue("betterHud.hud.seconds");
        settings.add(this.timeoutMax);
        this.showBurst = new SettingBoolean("showBurst");
        settings.add(this.showBurst);
        this.remember = new SettingBoolean("remember");
        settings.add(this.remember);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.SOUTH_WEST);
        this.timeoutMax.set(3.0);
        this.showBurst.set(true);
        this.remember.set(false);
        this.settings.priority.set(1);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Tickable.Ticker.FAST.register(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClick(InputEvent.MouseInputEvent event) {
        if (Mouse.getEventButton() != -1 && Mouse.getEventButtonState()) {
            int n = this.i;
            this.clickHistory[n] = this.clickHistory[n] + 1;
        }
    }

    @Override
    public void tick() {
        if ((double)this.timeout < this.timeoutMax.get() || this.clickHistory[this.i] > 0) {
            if (this.clickHistory[this.i] > 0) {
                if ((double)this.timeout == this.timeoutMax.get()) {
                    this.windowTotal = 0;
                    this.burstTotal = 0;
                    this.burstLength = 0;
                } else {
                    this.burstLength += this.timeout;
                }
                this.windowTotal += this.clickHistory[this.i];
                this.burstTotal += this.clickHistory[this.i];
                this.cps = (float)this.windowTotal / (float)Math.min(++this.burstLength, this.clickHistory.length);
                this.timeout = 0;
            } else if ((double)(++this.timeout) == this.timeoutMax.get()) {
                return;
            }
            this.next();
        }
    }

    private void next() {
        this.i = (this.i + 1) % this.clickHistory.length;
        if (this.burstLength + this.timeout >= this.clickHistory.length) {
            this.windowTotal -= this.clickHistory[this.i];
        }
        this.clickHistory[this.i] = 0;
    }

    @Override
    protected List<String> getText() {
        float cps = (double)this.timeout < this.timeoutMax.get() || this.remember.get() != false ? this.cps : 0.0f;
        String cpsDisplay = this.getLocalizedName() + ": " + MathUtil.formatToPlaces(cps, 1);
        if (this.showBurst.get().booleanValue() && cps > 0.0f) {
            return Arrays.asList(cpsDisplay, I18n.func_135052_a((String)"betterHud.hud.burst", (Object[])new Object[]{this.burstTotal, this.burstLength}));
        }
        return Arrays.asList(cpsDisplay);
    }
}

