/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.text;

import java.util.Arrays;
import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.text.TextElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Rect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Distance
extends TextElement {
    private SettingChoose mode;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.CENTER);
        this.mode.setIndex(0);
    }

    public Distance() {
        super("distance", new SettingPosition(DirectionOptions.X, DirectionOptions.WEST_EAST));
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        settings.add(new Legend("misc"));
        this.mode = new SettingChoose(3);
        settings.add(this.mode);
    }

    @Override
    protected Rect moveRect(Rect bounds) {
        if (this.position.isDirection(Direction.CENTER)) {
            return bounds.align(BetterHud.MANAGER.getScreen().getAnchor(Direction.CENTER).sub(5, 5), Direction.SOUTH_EAST);
        }
        return super.moveRect(bounds);
    }

    @Override
    protected Rect getPadding() {
        return Rect.createPadding(this.border ? 2 : 0);
    }

    @Override
    protected Rect render(Event event, List<String> text) {
        this.border = this.mode.getIndex() == 2;
        return super.render(event, text);
    }

    @Override
    protected List<String> getText() {
        RayTraceResult trace = Minecraft.func_71410_x().func_175606_aa().func_174822_a(200.0, 1.0f);
        if (trace != null) {
            long distance = Math.round(Math.sqrt(trace.func_178782_a().func_177957_d(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v)));
            if (this.mode.getIndex() == 2) {
                return Arrays.asList(String.valueOf(distance));
            }
            return Arrays.asList(I18n.func_135052_a((String)("betterHud.hud.distance." + this.mode.getIndex()), (Object[])new Object[]{String.valueOf(distance)}));
        }
        return null;
    }
}

