/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.text;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.element.text.Clock;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GameClock
extends Clock {
    private static final ItemStack BED = new ItemStack(Items.field_151104_aV, 1, 14);
    private SettingBoolean showDays;
    private SettingBoolean showSleepIndicator;
    private SettingChoose requireItem;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public GameClock() {
        super("gameClock");
        this.border = true;
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.showDays = new SettingBoolean("showDays").setValuePrefix("betterHud.value.visible");
        settings.add(this.showDays);
        this.showSleepIndicator = new SettingBoolean("showSleepIndicator").setValuePrefix("betterHud.value.visible");
        settings.add(this.showSleepIndicator);
        this.requireItem = new SettingChoose("requireItem", "disabled", "inventory", "hand");
        settings.add(this.requireItem);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.showDays.set(true);
        this.showSleepIndicator.set(false);
        this.requireItem.setIndex(0);
    }

    @Override
    protected Rect getMargin() {
        return new Rect(0, 0, 21, 0).align(Point.zero(), this.position.getContentAlignment());
    }

    @Override
    public boolean shouldRender(Event event) {
        if (!super.shouldRender(event)) {
            return false;
        }
        switch (this.requireItem.getIndex()) {
            case 1: {
                return Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70431_c(new ItemStack(Items.field_151113_aN));
            }
            case 2: {
                return Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == Items.field_151113_aN || Minecraft.func_71410_x().field_71439_g.func_184592_cb().func_77973_b() == Items.field_151113_aN;
            }
        }
        return true;
    }

    @Override
    public Rect render(Event event) {
        Rect bounds = super.render(event);
        float partialTicks = ((RenderGameOverlayEvent)event).getPartialTicks();
        if (this.showSleepIndicator(partialTicks)) {
            Direction bedAnchor = (Direction)((Object)DirectionOptions.WEST_EAST.apply(this.position.getContentAlignment().mirrorCol()));
            Rect bed = new Rect(16, 16).anchor(bounds, bedAnchor);
            GlUtil.renderSingleItem(BED, bed.getPosition());
        }
        return bounds;
    }

    private boolean showSleepIndicator(float partialTicks) {
        return this.showSleepIndicator.get() != false && Minecraft.func_71410_x().field_71441_e.field_73011_w.canSleepAt((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.func_180425_c()) == WorldProvider.WorldSleepResult.ALLOW && !Minecraft.func_71410_x().field_71439_g.func_70608_bn() && Minecraft.func_71410_x().field_71439_g.func_70089_S() && Minecraft.func_71410_x().field_71441_e.field_73011_w.func_76569_d() && Minecraft.func_71410_x().field_71441_e.func_72967_a(partialTicks) >= 4;
    }

    @Override
    protected Date getDate() {
        long worldTime = Minecraft.func_71410_x().field_71441_e.func_72820_D() + 6000L;
        worldTime = Math.round((double)worldTime / 1000.0 * 3600.0) * 1000L;
        return new Date(worldTime);
    }

    @Override
    protected DateFormat getTimeFormat() {
        DateFormat format = super.getTimeFormat();
        format.setTimeZone(UTC);
        return format;
    }

    @Override
    protected DateFormat getDateFormat() {
        if (this.showDays.get().booleanValue()) {
            return new DateFormat(){

                @Override
                public StringBuffer format(Date date, StringBuffer buffer, FieldPosition fieldPosition) {
                    long day = date.getTime() / 84600000L + 1L;
                    buffer.append(I18n.func_135052_a((String)"betterHud.hud.day", (Object[])new Object[]{day}));
                    return buffer;
                }

                @Override
                public Date parse(String source, ParsePosition pos) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        DateFormat format = super.getDateFormat();
        format.setTimeZone(UTC);
        return format;
    }
}

