/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.vanilla.OverrideElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.util.bars.StatBar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class Bar
extends OverrideElement {
    protected SettingChoose side;
    private StatBar<? super EntityPlayerSP> bar;

    public Bar(String name, StatBar<? super EntityPlayerSP> bar) {
        super(name, new SettingPosition(DirectionOptions.BAR, DirectionOptions.CORNERS));
        this.bar = bar;
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.side = new SettingChoose("side", new String[]{"west", "east"}){

            @Override
            public boolean enabled() {
                return Bar.this.position.isDirection(Direction.SOUTH);
            }
        };
        settings.add(this.side);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.SOUTH);
    }

    @Override
    public boolean shouldRender(Event event) {
        this.bar.setHost((EntityPlayerSP)Minecraft.func_71410_x().field_71439_g);
        return super.shouldRender(event) && this.bar.shouldRender();
    }

    protected Direction getContentAlignment() {
        if (this.position.isDirection(Direction.SOUTH)) {
            return this.side.getIndex() == 1 ? Direction.SOUTH_EAST : Direction.SOUTH_WEST;
        }
        return this.position.getContentAlignment();
    }

    @Override
    protected Rect render(Event event) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        Direction contentAlignment = this.getContentAlignment();
        Rect bounds = new Rect(this.bar.getPreferredSize());
        bounds = this.position.isDirection(Direction.SOUTH) ? BetterHud.MANAGER.positionBar(bounds, contentAlignment.withRow(1), 1) : this.position.applyTo(bounds);
        this.bar.setContentAlignment(contentAlignment).setBounds(bounds).render();
        return bounds;
    }
}

