/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.vanilla.OverrideElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Crosshair
extends OverrideElement {
    private SettingBoolean attackIndicator;
    private SettingChoose indicatorType;

    public Crosshair() {
        super("crosshair", new SettingPosition(DirectionOptions.I, DirectionOptions.NONE));
        this.position.setEnableOn(() -> this.attackIndicator.get());
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.attackIndicator = new SettingBoolean(null){

            @Override
            public Boolean get() {
                return Minecraft.func_71410_x().field_71474_y.field_186716_M != 0;
            }

            @Override
            public void set(Boolean value) {
                Minecraft.func_71410_x().field_71474_y.field_186716_M = value != false ? Crosshair.this.indicatorType.getIndex() + 1 : 0;
                Minecraft.func_71410_x().field_71474_y.func_74303_b();
            }
        };
        settings.add(this.attackIndicator);
        this.attackIndicator.setValuePrefix("betterHud.value.visible").setUnlocalizedName("options.attackIndicator");
        this.indicatorType = new SettingChoose(null, 2){

            @Override
            public boolean enabled() {
                return super.enabled() && Crosshair.this.attackIndicator.get() != false;
            }

            @Override
            public int getIndex() {
                return Math.max(Minecraft.func_71410_x().field_71474_y.field_186716_M - 1, 0);
            }

            @Override
            public void setIndex(int index) {
                if (index >= 0 && index < 2) {
                    Minecraft.func_71410_x().field_71474_y.field_186716_M = Crosshair.this.attackIndicator.get() != false ? index + 1 : 0;
                }
            }

            @Override
            protected String getUnlocalizedValue() {
                return "options.attack." + this.modes[this.getIndex()];
            }
        };
        settings.add(this.indicatorType);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.attackIndicator.set(true);
        this.indicatorType.setIndex(0);
        this.position.setPreset(Direction.CENTER);
    }

    @Override
    protected RenderGameOverlayEvent.ElementType getType() {
        return RenderGameOverlayEvent.ElementType.CROSSHAIRS;
    }

    @Override
    public boolean shouldRender(Event event) {
        return super.shouldRender(event) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && (!Minecraft.func_71410_x().field_71442_b.func_78747_a() || this.canInteract());
    }

    private boolean canInteract() {
        if (Minecraft.func_71410_x().field_147125_j != null) {
            return true;
        }
        RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
        if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockPos pos = trace.func_178782_a();
        IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
        return state.func_177230_c().hasTileEntity(state) && Minecraft.func_71410_x().field_71441_e.func_175625_s(pos) instanceof IInventory;
    }

    @Override
    protected Rect render(Event event) {
        Rect bounds = null;
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && !Minecraft.func_71410_x().field_71474_y.field_178879_v && !Minecraft.func_71410_x().field_71439_g.func_175140_cp()) {
            this.renderAxes(BetterHud.MANAGER.getScreen().getAnchor(Direction.CENTER), Crosshair.getPartialTicks(event));
        } else {
            Rect texture = new Rect(16, 16);
            Rect crosshair = new Rect(texture).anchor(BetterHud.MANAGER.getScreen(), Direction.CENTER).translate(1, 1);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
            GlStateManager.func_179141_d();
            GlUtil.drawRect(crosshair, texture);
            if (this.attackIndicator.get().booleanValue()) {
                bounds = this.renderAttackIndicator();
            }
            GlUtil.blendFuncSafe(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            GlStateManager.func_179118_c();
        }
        return bounds;
    }

    private Rect renderAttackIndicator() {
        Rect bounds;
        Rect rect = bounds = this.indicatorType.getIndex() == 0 ? new Rect(16, 8) : new Rect(18, 18);
        if (this.position.isDirection(Direction.SOUTH)) {
            Direction primary = Minecraft.func_71410_x().field_71439_g.func_184591_cq() == EnumHandSide.RIGHT ? Direction.EAST : Direction.WEST;
            bounds = bounds.align(HudElement.HOTBAR.getLastBounds().grow(5).getAnchor(primary), primary.mirrorCol()).translate(1, 0);
        } else {
            bounds = this.position.isDirection(Direction.CENTER) ? bounds.align(BetterHud.MANAGER.getScreen().getAnchor(Direction.CENTER).add(0, 9), Direction.NORTH) : this.position.applyTo(bounds);
        }
        float attackStrength = Minecraft.func_71410_x().field_71439_g.func_184825_o(0.0f);
        if (this.indicatorType.getIndex() == 0) {
            if (attackStrength >= 1.0f) {
                if (Minecraft.func_71410_x().field_147125_j instanceof EntityLivingBase && ((EntityLivingBase)Minecraft.func_71410_x().field_147125_j).func_70089_S() && Minecraft.func_71410_x().field_71439_g.func_184818_cX() > 5.0f) {
                    GlUtil.drawRect(bounds.resize(16, 16), new Rect(68, 94, 16, 16));
                }
            } else {
                GlUtil.drawTexturedProgressBar(bounds.getPosition(), new Rect(36, 94, 16, 8), new Rect(52, 94, 16, 8), attackStrength, Direction.EAST);
            }
        } else if (attackStrength < 1.0f) {
            GlUtil.blendFuncSafe(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            GlUtil.drawTexturedProgressBar(bounds.getPosition(), new Rect(0, 94, 18, 18), new Rect(18, 94, 18, 18), attackStrength, Direction.NORTH);
        }
        return bounds;
    }

    private void renderAxes(Point center, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)center.getX(), (float)center.getY(), (float)0.0f);
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
        OpenGlHelper.func_188785_m((int)10);
        GlStateManager.func_179121_F();
    }
}

