/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.events.RenderEvents;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class OverrideElement
extends HudElement {
    protected OverrideElement(String name) {
        super(name);
    }

    protected OverrideElement(String name, SettingPosition position) {
        super(name, position);
    }

    protected abstract RenderGameOverlayEvent.ElementType getType();

    private static boolean safePost(Event event) {
        boolean cancel = MinecraftForge.EVENT_BUS.post(event);
        RenderEvents.beginOverlayState();
        return cancel;
    }

    @Override
    public boolean shouldRender(Event event) {
        if (!(event instanceof RenderGameOverlayEvent)) {
            return false;
        }
        RenderGameOverlayEvent parent = (RenderGameOverlayEvent)event;
        RenderGameOverlayEvent.Pre child = new RenderGameOverlayEvent.Pre(parent, this.getType());
        return !OverrideElement.safePost((Event)child);
    }

    @Override
    protected void postRender(Event event) {
        RenderGameOverlayEvent.ElementType type;
        if (event instanceof RenderGameOverlayEvent && (type = this.getType()) != null) {
            RenderGameOverlayEvent e = (RenderGameOverlayEvent)event;
            OverrideElement.safePost((Event)new RenderGameOverlayEvent.Post(e, type));
        }
    }
}

