/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.DefaultBoxed;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.render.Quad;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;

public class PotionIcon
extends DefaultBoxed {
    private final PotionEffect effect;
    private final Potion potion;
    private final boolean showDuration;

    public PotionIcon(PotionEffect effect, boolean showDuration) {
        this.effect = effect;
        this.potion = effect.func_188419_a();
        this.showDuration = showDuration;
    }

    @Override
    public void render() {
        String durationLabel;
        Color iconColor = this.getIconColor();
        Rect background = this.getIconBackground();
        Rect iconBounds = background.anchor(this.bounds, Direction.NORTH);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiContainer.field_147001_a);
        new Quad().setTexture(background).setBounds(iconBounds).render();
        iconColor.apply();
        Rect iconInnerBounds = new Rect(18, 18).anchor(iconBounds, Direction.CENTER);
        if (this.potion.func_76400_d()) {
            int index = this.potion.func_76392_e();
            Rect icon = new Rect(index % 8 * 18, 198 + index / 8 * 18, 18, 18);
            new Quad().setTexture(icon).setBounds(iconInnerBounds).render();
        }
        this.potion.renderHUDEffect(iconBounds.getX(), iconBounds.getY(), this.effect, Minecraft.func_71410_x(), (float)iconColor.getAlpha() / 255.0f);
        String levelLabel = this.getLevelLabel();
        if (levelLabel != null) {
            Label label = new Label(levelLabel);
            label.setBounds(new Rect(label.getPreferredSize()).anchor(iconInnerBounds, Direction.SOUTH_EAST)).render();
        }
        if ((durationLabel = this.getDurationLabel()) != null) {
            Label label = new Label(durationLabel);
            label.setBounds(new Rect(label.getPreferredSize()).anchor(iconBounds.grow(2), Direction.SOUTH, true)).render();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        Color.WHITE.apply();
    }

    @Override
    public Size negotiateSize(Point size) {
        String label = this.getDurationLabel();
        if (label == null) {
            return new Size(24, 24);
        }
        Size labelSize = new Label(label).getPreferredSize();
        int width = Math.max(24, labelSize.getWidth());
        return new Size(width, 26 + labelSize.getHeight());
    }

    private String getDurationLabel() {
        if (this.potion.shouldRenderInvText(this.effect) && this.showDuration) {
            return Potion.func_188410_a((PotionEffect)this.effect, (float)1.0f);
        }
        return null;
    }

    private String getLevelLabel() {
        String unlocalized;
        int amplifier;
        if (this.potion.shouldRenderInvText(this.effect) && (amplifier = this.effect.func_76458_c()) > 0 && I18n.func_188566_a((String)(unlocalized = "enchantment.level." + (amplifier + 1)))) {
            return I18n.func_135052_a((String)unlocalized, (Object[])new Object[0]);
        }
        return null;
    }

    private Color getIconColor() {
        if (this.effect.func_82720_e() || this.effect.func_76459_b() > 200) {
            return Color.WHITE;
        }
        int duration = this.effect.func_76459_b();
        double center = MathHelper.func_151237_a((double)((double)duration / 100.0), (double)0.0, (double)0.5);
        double oscillate = Math.cos(0.6283185307179586 * (double)duration) * MathHelper.func_151237_a((double)(10.0 - (double)duration / 800.0), (double)0.0, (double)0.25);
        return Color.WHITE.withAlpha((int)Math.round((center + oscillate) * 255.0));
    }

    private Rect getIconBackground() {
        return new Rect(this.effect.func_82720_e() ? 165 : 141, 166, 24, 24);
    }
}

