/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.events;

import com.google.common.base.Predicate;
import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.events.RenderMobInfoEvent;
import jobicade.betterhud.events.SnapshotTracker;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.GlSnapshot;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class RenderEvents {
    private final SnapshotTracker overlayTracker = new SnapshotTracker(BetterHud.getLogger());
    private final SnapshotTracker mobInfoTracker = new SnapshotTracker(BetterHud.getLogger());

    @SubscribeEvent
    public void onRenderTick(RenderGameOverlayEvent.Pre event) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("betterhud");
        boolean enabled = BetterHud.getProxy().isModEnabled();
        RenderEvents.suppressVanilla(enabled);
        if (enabled && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.renderOverlay(event);
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    @SubscribeEvent
    public void worldRender(RenderWorldLastEvent event) {
        Entity entity;
        Minecraft.func_71410_x().field_71424_I.func_76320_a("betterhud");
        if (BetterHud.getProxy().isModEnabled() && (entity = RenderEvents.getMouseOver(HudElement.GLOBAL.getBillboardDistance(), event.getPartialTicks())) instanceof EntityLivingBase) {
            this.renderMobInfo(new RenderMobInfoEvent(event, (EntityLivingBase)entity));
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public static void beginOverlayState() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179103_j((int)7425);
    }

    public static void endOverlayState() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_179103_j((int)7424);
    }

    private static void suppressVanilla(boolean suppress) {
        boolean allow = !suppress;
        GuiIngameForge.renderHotbar = allow || Minecraft.func_71410_x().field_71439_g.func_175149_v();
        GuiIngameForge.renderExperiance = allow;
        GuiIngameForge.renderHealth = allow;
        GuiIngameForge.renderArmor = allow;
        GuiIngameForge.renderAir = allow;
        GuiIngameForge.renderHelmet = allow;
        GuiIngameForge.renderVignette = allow;
        GuiIngameForge.renderObjective = allow;
        GuiIngameForge.renderCrosshairs = allow;
        GuiIngameForge.renderPortal = allow;
        GuiIngameForge.renderFood = GuiIngameForge.renderFood && allow;
        GuiIngameForge.renderJumpBar = GuiIngameForge.renderJumpBar && allow;
        GuiIngameForge.renderHealthMount = GuiIngameForge.renderHealthMount && allow;
    }

    private void renderOverlay(RenderGameOverlayEvent.Pre event) {
        BetterHud.MANAGER.reset(event.getResolution());
        RenderEvents.beginOverlayState();
        if (HudElement.GLOBAL.isDebugMode()) {
            GlSnapshot pre = new GlSnapshot();
            HudElement.renderAll((Event)event);
            this.overlayTracker.step(pre, new GlSnapshot());
        } else {
            HudElement.renderAll((Event)event);
        }
        RenderEvents.endOverlayState();
    }

    private void renderMobInfo(RenderMobInfoEvent event) {
        BetterHud.MANAGER.reset(Point.zero());
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        Color.WHITE.apply();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179094_E();
        GlUtil.setupBillboard((Entity)event.getEntity(), event.getPartialTicks(), HudElement.GLOBAL.getBillboardScale());
        if (HudElement.GLOBAL.isDebugMode()) {
            GlSnapshot pre = new GlSnapshot();
            HudElement.renderAll((Event)event);
            this.mobInfoTracker.step(pre, new GlSnapshot());
        } else {
            HudElement.renderAll((Event)event);
        }
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
    }

    private static Entity getMouseOver(double distance, float partialTicks) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return null;
        }
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            return null;
        }
        Entity pointedEntity = null;
        Minecraft.func_71410_x().field_71424_I.func_76320_a("pick");
        RayTraceResult trace = viewEntity.func_174822_a(distance, partialTicks);
        Vec3d eyePosition = viewEntity.func_174824_e(partialTicks);
        Vec3d lookDelta = viewEntity.func_70040_Z().func_186678_a(distance);
        if (trace != null) {
            distance = trace.field_72307_f.func_72438_d(eyePosition);
        }
        AxisAlignedBB range = viewEntity.func_174813_aQ().func_72321_a(lookDelta.field_72450_a, lookDelta.field_72448_b, lookDelta.field_72449_c).func_72314_b(1.0, 1.0, 1.0);
        List entitiesInRange = Minecraft.func_71410_x().field_71441_e.func_175674_a(viewEntity, range, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                return entity != null && entity.func_70067_L();
            }
        });
        for (Entity entity : entitiesInRange) {
            double entityDistance;
            AxisAlignedBB entityBox = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult entityTrace = entityBox.func_72327_a(eyePosition, eyePosition.func_178787_e(lookDelta));
            if (entityBox.func_72318_a(eyePosition)) {
                if (!(distance >= 0.0)) continue;
                pointedEntity = entity;
                distance = 0.0;
                continue;
            }
            if (entityTrace == null || !((entityDistance = eyePosition.func_72438_d(entityTrace.field_72307_f)) < distance) && distance != 0.0) continue;
            if (entity.func_184208_bv() == viewEntity.func_184208_bv() && !entity.canRiderInteract()) {
                if (distance != 0.0) continue;
                pointedEntity = entity;
                continue;
            }
            pointedEntity = entity;
            distance = entityDistance;
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        return pointedEntity;
    }
}

