/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.events;

import jobicade.betterhud.render.GlSnapshot;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class SnapshotTracker {
    private final Logger logger;
    private GlSnapshot lastWarningPre = null;
    private GlSnapshot lastWarningPost = null;

    public SnapshotTracker(Logger logger) {
        this.logger = logger;
    }

    public void step(GlSnapshot pre, GlSnapshot post) {
        if (!pre.equals(post)) {
            if (!pre.equals(this.lastWarningPre) || !post.equals(this.lastWarningPost)) {
                this.logger.printf(Level.WARN, "OpenGL state inconsistency\nPre:  %s\nPost: %s", new Object[]{pre, post});
                this.lastWarningPre = pre;
                this.lastWarningPost = post;
            }
        } else if (this.lastWarningPre != null || this.lastWarningPost != null) {
            this.logger.log(Level.INFO, "OpenGL inconsistency resolved");
            this.lastWarningPre = null;
            this.lastWarningPost = null;
        }
    }
}

