/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.geom;

import jobicade.betterhud.geom.Point;
import net.minecraft.client.gui.ScaledResolution;

public class Size
extends Point {
    private static final long serialVersionUID = 1L;
    private static final Size ZERO = new Size();

    public Size() {
    }

    public Size(int width, int height) {
        super(width, height);
    }

    public Size(Point point) {
        super(point);
    }

    public Size(ScaledResolution resolution) {
        super(resolution);
    }

    @Override
    public Size toSize() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Size && super.equals(obj);
    }

    @Override
    public String toString() {
        return String.format("%s{width: %d, height: %d}@%s", this.getClass().getName(), this.x, this.y, Integer.toHexString(System.identityHashCode(this)));
    }

    public static Size zero() {
        return ZERO;
    }

    public int getWidth() {
        return this.getX();
    }

    public int getHeight() {
        return this.getY();
    }

    @Override
    public Size withX(int x) {
        return new Size(x, this.y);
    }

    @Override
    public Size withY(int y) {
        return new Size(this.x, y);
    }

    public Size withWidth(int width) {
        return this.withX(width);
    }

    public Size withHeight(int height) {
        return this.withY(height);
    }

    @Override
    public Size add(int x, int y) {
        return new Size(this.x + x, this.y + y);
    }

    @Override
    public Size add(Point point) {
        return new Size(this.x + point.x, this.y + point.y);
    }

    @Override
    public Size invert() {
        return new Size(-this.x, -this.y);
    }

    @Override
    public Size scale(float factor) {
        return new Size(Math.round((float)this.x * factor), Math.round((float)this.y * factor));
    }

    @Override
    public Size scale(float xf, float yf) {
        return new Size(Math.round((float)this.x * xf), Math.round((float)this.y * yf));
    }

    @Override
    public Size scale(Point factor) {
        return new Size(this.x * factor.x, this.y * factor.y);
    }

    @Override
    public Size scale(float xf, float yf, int x, int y) {
        return new Size(Math.round((float)(this.x - x) * xf + (float)x), Math.round((float)(this.y - y) * yf + (float)y));
    }

    @Override
    public Size scale(float xf, float yf, Point point) {
        return this.scale(xf, yf, point.x, point.y);
    }
}

