/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.gui;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import jobicade.betterhud.config.ConfigManager;
import jobicade.betterhud.config.ConfigSlot;
import jobicade.betterhud.config.FileConfigSlot;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.gui.GuiActionButton;
import jobicade.betterhud.gui.GuiScrollbar;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.DefaultBoxed;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class GuiConfigSaves
extends GuiScreen {
    private GuiTextField name;
    private GuiScrollbar scrollbar;
    private Rect viewport;
    private final GuiScreen previous;
    private final ConfigManager manager;
    private Grid<ListItem> list;
    private ConfigSlot selected;
    private GuiActionButton load;
    private GuiActionButton save;

    public GuiConfigSaves(ConfigManager manager, GuiScreen previous) {
        this.previous = previous;
        this.manager = manager;
    }

    private ConfigSlot getSelectedEntry() {
        if (StringUtils.isBlank((CharSequence)this.name.func_146179_b())) {
            return null;
        }
        return this.list.getSource().stream().map(li -> ((ListItem)li).entry).filter(e -> e.matches(this.name.func_146179_b())).findFirst().orElseGet(() -> new FileConfigSlot(this.manager.getRootDirectory().resolve(this.name.func_146179_b() + ".cfg")));
    }

    private void updateSelected() {
        this.selected = this.getSelectedEntry();
        this.load.field_146124_l = this.selected != null;
        this.save.field_146124_l = this.selected != null && this.selected.isDest();
    }

    private void save() {
        try {
            this.manager.getConfig().saveSettings();
            this.selected.copyFrom(this.manager.getConfigPath());
            this.updateList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void load() {
        try {
            this.selected.copyTo(this.manager.getConfigPath());
            this.manager.reloadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Point origin = new Point(this.field_146294_l / 2, this.field_146295_m / 16 + 20);
        this.field_146292_n.add(new GuiActionButton(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])).setCallback(b -> Minecraft.func_71410_x().func_147108_a(this.previous)).setBounds(new Rect(200, 20).align(origin, Direction.NORTH)));
        Rect textField = new Rect(150, 20);
        Rect smallButton = new Rect(50, 20);
        Rect fieldLine = new Rect(textField.getWidth() + (5 + smallButton.getWidth()) * 2, 20).align(origin.add(0, 25), Direction.NORTH);
        textField = textField.anchor(fieldLine, Direction.NORTH_WEST);
        this.name = new GuiTextField(0, this.field_146289_q, textField.getX(), textField.getY(), textField.getWidth(), textField.getHeight());
        this.name.func_146195_b(true);
        this.name.func_146205_d(false);
        smallButton = smallButton.move(textField.getAnchor(Direction.NORTH_EAST).add(5, 0));
        this.load = new GuiActionButton("Load").setCallback(b -> this.load()).setBounds(smallButton);
        this.field_146292_n.add(this.load);
        smallButton = smallButton.move(smallButton.getAnchor(Direction.NORTH_EAST).add(5, 0));
        this.save = new GuiActionButton("Save").setCallback(b -> this.save()).setBounds(smallButton);
        this.field_146292_n.add(this.save);
        this.viewport = new Rect(400, 0).align(fieldLine.getAnchor(Direction.SOUTH).add(0, 5), Direction.NORTH).withBottom(this.field_146295_m - 20);
        this.scrollbar = new GuiScrollbar(this.viewport, 0);
        this.updateList();
    }

    private void updateList() {
        List listItems = this.manager.getSlots().stream().map(x$0 -> new ListItem((ConfigSlot)x$0)).collect(Collectors.toList());
        this.list = new Grid(new Point(1, listItems.size()), listItems);
        this.list.setStretch(true);
        this.scrollbar.setContentHeight(this.list.getPreferredSize().getHeight());
        this.updateSelected();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.name.func_146178_a();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.name.func_146201_a(typedChar, keyCode);
        this.updateSelected();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.name.func_146192_a(mouseX, mouseY, mouseButton);
        this.scrollbar.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.viewport.contains(mouseX, mouseY)) {
            for (int i = 0; i < this.list.getSource().size(); ++i) {
                Rect listBounds = this.getListBounds();
                if (!this.list.getCellBounds(listBounds, new Point(0, i)).contains(mouseX, mouseY)) continue;
                this.name.func_146180_a(this.list.getSource().get(i).entry.getName());
                this.updateSelected();
            }
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long heldTime) {
        super.func_146273_a(mouseX, mouseY, button, heldTime);
        this.scrollbar.mouseClickMove(mouseX, mouseY, button, heldTime);
    }

    public void func_146286_b(int mouseX, int mouseY, int button) {
        super.func_146286_b(mouseX, mouseY, button);
        this.scrollbar.mouseReleased(mouseX, mouseY, button);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scrollbar.handleMouseInput();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiActionButton) {
            ((GuiActionButton)button).actionPerformed();
        }
    }

    private Rect getListBounds() {
        Size origin = this.viewport.getAnchor(Direction.NORTH).sub(0, this.scrollbar.getScroll() - 5);
        return new Rect(this.list.getPreferredSize().withWidth(300)).align(origin, Direction.NORTH);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.name.func_146194_f();
        Rect scissorRect = this.viewport.withY(this.field_146295_m - this.viewport.getBottom()).scale(new ScaledResolution(Minecraft.func_71410_x()).func_78325_e());
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorRect.getX(), (int)scissorRect.getY(), (int)scissorRect.getWidth(), (int)scissorRect.getHeight());
        this.list.setBounds(this.getListBounds()).render();
        GL11.glDisable((int)3089);
        this.scrollbar.drawScrollbar(mouseX, mouseY);
    }

    private class ListItem
    extends DefaultBoxed {
        private final ConfigSlot entry;
        private final Label label;

        private ListItem(ConfigSlot entry) {
            this.entry = entry;
            this.label = new Label(entry.getName());
            if (!entry.isDest()) {
                this.label.setColor(Color.GRAY);
            }
        }

        @Override
        public Size getPreferredSize() {
            return this.label.getPreferredSize().add(40, 0).withHeight(20);
        }

        @Override
        public Size negotiateSize(Point size) {
            Size labelSize = this.label.getPreferredSize();
            int minWidth = labelSize.getWidth() + 5;
            int minHeight = Math.max(labelSize.getHeight(), 20);
            return new Size(Math.max(minWidth, size.getX()), Math.max(minHeight, size.getY()));
        }

        @Override
        public void render() {
            if (GuiConfigSaves.this.selected == this.entry) {
                GlUtil.drawRect(this.bounds, new Color(48, 0, 0, 0));
                GlUtil.drawBorderRect(this.bounds, new Color(160, 144, 144, 144));
            }
            this.label.setBounds(new Rect(this.label.getPreferredSize()).anchor(this.bounds, Direction.CENTER)).render();
        }
    }
}

