/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.gui.GuiActionButton;
import jobicade.betterhud.gui.GuiMenuScreen;
import jobicade.betterhud.gui.GuiScrollbar;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiElementSettings
extends GuiMenuScreen {
    private static final int REPEAT_SPEED = 20;
    private static final int REPEAT_SPEED_FAST = 10;
    public HudElement element;
    private ArrayList<GuiTextField> textboxList = new ArrayList();
    public HashMap<Gui, Setting<?>> callbacks = new HashMap();
    private Rect viewport;
    private final GuiActionButton done = new GuiActionButton(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
    private GuiScrollbar scrollbar;
    private int repeatTimer = 0;

    public GuiElementSettings(HudElement element, GuiScreen prev) {
        this.element = element;
        this.done.setCallback(b -> Minecraft.func_71410_x().func_147108_a(prev));
    }

    public void func_73866_w_() {
        this.setTitle(I18n.func_135052_a((String)"betterHud.menu.settings", (Object[])new Object[]{this.element.getLocalizedName()}));
        this.field_146292_n.clear();
        this.textboxList.clear();
        this.field_146293_o.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.done.setBounds(new Rect(200, 20).align(this.getOrigin(), Direction.NORTH));
        ArrayList<Gui> parts = new ArrayList<Gui>();
        int contentHeight = this.element.settings.getGuiParts(parts, this.callbacks, new Point(this.field_146294_l / 2, 5)).getY();
        for (Gui gui : parts) {
            if (gui instanceof GuiButton) {
                this.field_146292_n.add((GuiButton)gui);
                continue;
            }
            if (gui instanceof GuiLabel) {
                this.field_146293_o.add((GuiLabel)gui);
                continue;
            }
            if (!(gui instanceof GuiTextField)) continue;
            this.textboxList.add((GuiTextField)gui);
        }
        this.viewport = new Rect(this.field_146294_l / 2 - 200, this.field_146295_m / 16 + 40 + 5, 400, 0).withBottom(this.field_146295_m - 20);
        this.scrollbar = new GuiScrollbar(this.viewport, contentHeight);
        for (Setting setting : this.callbacks.values()) {
            setting.updateGuiParts(this.callbacks.values());
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        BetterHud.getProxy().getConfig().saveSettings();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (this.callbacks.containsKey(button)) {
            this.callbacks.get(button).actionPerformed(this, button);
            for (Setting<?> setting : this.callbacks.values()) {
                setting.updateGuiParts(this.callbacks.values());
            }
        } else {
            super.func_146284_a(button);
        }
    }

    public void func_73876_c() {
        for (GuiTextField field : this.textboxList) {
            field.func_146178_a();
        }
        if (this.field_146290_a instanceof GuiActionButton && ((GuiActionButton)this.field_146290_a).getRepeat()) {
            if (++this.repeatTimer % Math.max(1, Math.round(20 / this.repeatTimer)) == 0) {
                int c = Math.max(1, (this.repeatTimer - 20) / 10);
                for (int i = 0; i < c; ++i) {
                    this.func_146284_a(this.field_146290_a);
                }
            }
        } else {
            this.repeatTimer = 0;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        for (GuiTextField field : this.textboxList) {
            field.func_146201_a(typedChar, keyCode);
            if (!this.callbacks.containsKey(field)) continue;
            this.callbacks.get(field).updateGuiParts(this.callbacks.values());
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scrollbar.handleMouseInput();
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (mouseY >= this.viewport.getTop() && mouseY < this.viewport.getBottom()) {
            super.func_73864_a(mouseX, mouseY + this.getMouseOffset(), button);
            for (GuiTextField field : this.textboxList) {
                field.func_146192_a(mouseX, mouseY + this.getMouseOffset(), button);
            }
        }
        if (this.done.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
            GuiButton eventResult;
            GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, (GuiButton)this.done, this.field_146292_n);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            this.field_146290_a = eventResult = event.getButton();
            eventResult.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(eventResult);
            if (((Object)((Object)this)).equals(Minecraft.func_71410_x().field_71462_r)) {
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, (GuiButton)this.done, this.field_146292_n));
            }
        }
        this.scrollbar.mouseClicked(mouseX, mouseY, button);
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long heldTime) {
        super.func_146273_a(mouseX, mouseY + this.getMouseOffset(), button, heldTime);
        this.scrollbar.mouseClickMove(mouseX, mouseY, button, heldTime);
    }

    public void func_146286_b(int mouseX, int mouseY, int button) {
        super.func_146286_b(mouseX, mouseY + this.getMouseOffset(), button);
        this.scrollbar.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawTitle();
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        this.done.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlUtil.beginScissor(this.viewport, resolution);
        GL11.glTranslatef((float)0.0f, (float)(-this.getMouseOffset()), (float)0.0f);
        int viewportMouseY = mouseY + this.getMouseOffset();
        for (GuiButton button : this.field_146292_n) {
            button.func_191745_a(this.field_146297_k, mouseX, viewportMouseY, partialTicks);
        }
        for (GuiLabel label : this.field_146293_o) {
            label.func_146159_a(this.field_146297_k, mouseX, viewportMouseY);
        }
        for (GuiTextField field : this.textboxList) {
            field.func_146194_f();
        }
        this.element.settings.draw();
        GlUtil.endScissor();
        GlStateManager.func_179121_F();
        this.scrollbar.drawScrollbar(mouseX, mouseY);
        this.drawResolution(10, 10, 100);
    }

    @Deprecated
    private int getMouseOffset() {
        return this.scrollbar.getScroll() - this.viewport.getTop();
    }

    private void drawResolution(int x, int y, int width) {
        int height = width * this.field_146295_m / this.field_146294_l;
        String widthDisplay = String.valueOf(this.field_146294_l);
        int stringWidth = this.field_146289_q.func_78256_a(widthDisplay);
        int textX = x + (width - stringWidth) / 2;
        this.func_73730_a(x, textX - 5, y, Color.WHITE.getPacked());
        this.func_73730_a(x + (width + stringWidth) / 2 + 5, x + width, y, Color.WHITE.getPacked());
        this.field_146289_q.func_78276_b(widthDisplay, textX, y, Color.WHITE.getPacked());
        int textY = y + (height - this.field_146289_q.field_78288_b) / 2;
        this.func_73728_b(x, y, textY - 5, Color.WHITE.getPacked());
        this.func_73728_b(x, y + (height + this.field_146289_q.field_78288_b) / 2 + 5, y + height, Color.WHITE.getPacked());
        this.field_146289_q.func_78276_b(String.valueOf(this.field_146295_m), x, textY, Color.WHITE.getPacked());
    }
}

