/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jobicade.betterhud.config.ConfigManager;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.gui.ButtonRow;
import jobicade.betterhud.gui.GuiActionButton;
import jobicade.betterhud.gui.GuiConfigSaves;
import jobicade.betterhud.gui.GuiMenuScreen;
import jobicade.betterhud.gui.GuiReorder;
import jobicade.betterhud.gui.SortButton;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import jobicade.betterhud.util.Paginator;
import jobicade.betterhud.util.SortField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class GuiHudMenu
extends GuiMenuScreen {
    private final Map<HudElement, ButtonRow> rows = new HashMap<HudElement, ButtonRow>(HudElement.ELEMENTS.size());
    final Paginator<HudElement> paginator = new Paginator();
    private final GuiActionButton returnToGame = new GuiActionButton(I18n.func_135052_a((String)"menu.returnToGame", (Object[])new Object[0])).setCallback(b -> Minecraft.func_71410_x().func_147108_a(null));
    private final GuiActionButton toggleAll = new GuiActionButton("").setCallback(b -> this.setAll(!this.allEnabled()));
    private final GuiActionButton reorder = new GuiActionButton(I18n.func_135052_a((String)"betterHud.menu.reorder", (Object[])new Object[0])).setCallback(b -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiReorder(this)));
    private final GuiActionButton resetDefaults = new GuiActionButton(I18n.func_135052_a((String)"betterHud.menu.saveLoad", (Object[])new Object[0]));
    private final ButtonRow globalRow = new ButtonRow(this, HudElement.GLOBAL);
    private final GuiActionButton lastPage = new GuiActionButton(I18n.func_135052_a((String)"betterHud.menu.lastPage", (Object[])new Object[0])).setCallback(b -> {
        this.paginator.previousPage();
        this.func_73866_w_();
    });
    private final GuiActionButton nextPage = new GuiActionButton(I18n.func_135052_a((String)"betterHud.menu.nextPage", (Object[])new Object[0])).setCallback(b -> {
        this.paginator.nextPage();
        this.func_73866_w_();
    });
    private SortField<HudElement> sortCriteria = HudElement.SortType.ALPHABETICAL;
    private boolean descending;

    public GuiHudMenu(ConfigManager configManager) {
        this.resetDefaults.setCallback(button -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConfigSaves(configManager, this)));
    }

    public SortField<HudElement> getSortCriteria() {
        return this.sortCriteria;
    }

    public boolean isDescending() {
        return this.descending;
    }

    private boolean allEnabled() {
        return HudElement.ELEMENTS.stream().allMatch(e -> e.get());
    }

    public void func_73866_w_() {
        this.setTitle(I18n.func_135052_a((String)"betterHud.menu.hudSettings", (Object[])new Object[0]));
        this.paginator.setData(HudElement.SORTER.getSortedData(this.sortCriteria, this.descending ^ this.sortCriteria.isInverted()));
        this.paginator.setPageSize(Math.max(1, (int)Math.floor((this.field_146295_m / 8 * 7 - 134) / 24)));
        this.addDefaultButtons();
        Rect buttonRect = new Rect(170, 20).align(this.getOrigin().add(0, 82), Direction.NORTH);
        for (HudElement element : this.paginator.getPage()) {
            ButtonRow row = this.getRow(element);
            this.field_146292_n.addAll(row.getButtons());
            row.setBounds(buttonRect);
            row.update();
            buttonRect = buttonRect.withY(buttonRect.getBottom() + 4);
        }
    }

    private void addDefaultButtons() {
        Rect buttons = new Rect(300, 42).align(this.getOrigin(), Direction.NORTH);
        Rect halfWidth = new Rect((buttons.getWidth() - 2) / 2, 20);
        Rect thirdWidth = new Rect((buttons.getWidth() - 4) / 3, 20);
        this.returnToGame.setBounds(halfWidth.anchor(buttons, Direction.NORTH_WEST));
        this.globalRow.setBounds(halfWidth.anchor(buttons, Direction.NORTH_EAST));
        this.toggleAll.setBounds(thirdWidth.anchor(buttons, Direction.SOUTH_WEST));
        this.reorder.setBounds(thirdWidth.anchor(buttons, Direction.SOUTH));
        this.resetDefaults.setBounds(thirdWidth.anchor(buttons, Direction.SOUTH_EAST));
        this.toggleAll.field_146126_j = I18n.func_135052_a((String)(this.allEnabled() ? "betterHud.menu.disableAll" : "betterHud.menu.enableAll"), (Object[])new Object[0]);
        this.lastPage.field_146124_l = this.paginator.hasPrevious();
        this.nextPage.field_146124_l = this.paginator.hasNext();
        buttons = buttons.align(new Point(this.field_146294_l / 2, this.field_146295_m - 20 - this.field_146295_m / 16), Direction.NORTH);
        this.lastPage.setBounds(thirdWidth.anchor(buttons, Direction.NORTH_WEST));
        this.nextPage.setBounds(thirdWidth.anchor(buttons, Direction.NORTH_EAST));
        this.field_146292_n.clear();
        this.field_146292_n.add(this.returnToGame);
        this.field_146292_n.addAll(this.globalRow.getButtons());
        this.globalRow.update();
        this.field_146292_n.add(this.toggleAll);
        this.field_146292_n.add(this.reorder);
        this.field_146292_n.add(this.resetDefaults);
        this.field_146292_n.add(this.lastPage);
        this.field_146292_n.add(this.nextPage);
        List<GuiActionButton> indexerControls = this.getIndexControls(HudElement.SortType.values());
        Rect sortButton = new Rect(75, 20);
        Rect bounds = sortButton.withWidth((sortButton.getWidth() + 5) * indexerControls.size() - 5).align(this.getOrigin().add(0, 58), Direction.NORTH);
        sortButton = sortButton.move(bounds.getPosition());
        for (GuiActionButton button : indexerControls) {
            button.setBounds(sortButton);
            sortButton = sortButton.withX(sortButton.getRight() + 5);
        }
        this.field_146292_n.addAll(indexerControls);
    }

    private void setAll(boolean enabled) {
        for (HudElement element : HudElement.ELEMENTS) {
            element.set(enabled);
        }
        HudElement.SORTER.markDirty(HudElement.SortType.ENABLED);
        this.func_73866_w_();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
        int enabled = (int)HudElement.ELEMENTS.stream().filter(HudElement::get).count();
        GlUtil.drawString(enabled + "/" + HudElement.ELEMENTS.size() + " enabled", new Point(5, 5), Direction.NORTH_WEST, Color.WHITE);
        String page = I18n.func_135052_a((String)"betterHud.menu.page", (Object[])new Object[]{this.paginator.getPageIndex() + 1 + "/" + this.paginator.getPageCount()});
        this.func_73732_a(this.field_146289_q, page, this.field_146294_l / 2, this.field_146295_m - this.field_146295_m / 16 - 13, Color.WHITE.getPacked());
    }

    private List<GuiActionButton> getIndexControls(SortField<HudElement>[] sortValues) {
        ArrayList<GuiActionButton> buttons = new ArrayList<GuiActionButton>(sortValues.length);
        for (SortField<HudElement> sortValue : sortValues) {
            buttons.add(new SortButton(this, sortValue));
        }
        return buttons;
    }

    private ButtonRow getRow(HudElement element) {
        return this.rows.computeIfAbsent(element, e -> new ButtonRow(this, (HudElement)e));
    }

    public void changeSort(SortField<HudElement> sortCriteria) {
        if (this.sortCriteria == sortCriteria) {
            this.descending = !this.descending;
        } else {
            this.sortCriteria = sortCriteria;
            this.descending = sortCriteria.isInverted();
        }
        this.func_73866_w_();
    }
}

