/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.gui;

import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class GuiScrollbar
extends Gui {
    private final Rect bounds;
    private Rect grabber;
    private float scaleFactor;
    private final Color background;
    private final Color foreground;
    private final Color highlight;
    private int viewportHeight;
    private int contentHeight;
    private int clickOffset = -1;
    private int scroll;

    public GuiScrollbar(Rect viewport, int content) {
        this(new Rect(8, viewport.getHeight()).anchor(viewport, Direction.NORTH_EAST), viewport.getHeight(), content);
    }

    public GuiScrollbar(Rect bounds, int viewport, int content) {
        this(bounds, viewport, content, Color.TRANSLUCENT, Color.FOREGROUND, Color.HIGHLIGHT);
    }

    public GuiScrollbar(Rect bounds, int viewport, int content, Color background, Color foreground, Color highlight) {
        this.bounds = bounds;
        this.viewportHeight = viewport;
        this.contentHeight = content;
        this.updateGrabber();
        this.background = background;
        this.foreground = foreground;
        this.highlight = highlight;
    }

    public int getScroll() {
        return this.scroll;
    }

    public int getMaxScroll() {
        return this.contentHeight - this.viewportHeight;
    }

    public boolean canScroll() {
        return this.viewportHeight > 0 && this.contentHeight > this.viewportHeight;
    }

    public boolean isScrolling() {
        return this.clickOffset != -1;
    }

    public void setContentHeight(int contentHeight) {
        if (this.contentHeight != contentHeight) {
            this.contentHeight = contentHeight;
            this.updateGrabber();
        }
    }

    public void setViewportHeight(int viewportHeight) {
        if (this.viewportHeight != viewportHeight) {
            this.viewportHeight = viewportHeight;
            this.updateGrabber();
        }
    }

    public void setScroll(int scroll) {
        if (this.scroll != scroll) {
            this.scroll = scroll;
            this.updateGrabber();
        }
    }

    private void updateGrabber() {
        if (this.canScroll()) {
            this.scaleFactor = (float)this.viewportHeight / (float)this.contentHeight;
            this.scroll = MathHelper.func_76125_a((int)this.scroll, (int)0, (int)(this.contentHeight - this.viewportHeight));
            this.grabber = new Rect(this.bounds.getX(), this.bounds.getY() + (int)((float)this.scroll * this.scaleFactor), this.bounds.getWidth(), (int)(this.scaleFactor * (float)this.bounds.getHeight()));
        }
    }

    public void drawScrollbar(int mouseX, int mouseY) {
        GlUtil.drawRect(this.bounds, this.background);
        if (this.canScroll()) {
            Color grabColor = this.isScrolling() || this.bounds.contains(mouseX, mouseY) ? this.highlight : this.foreground;
            GlUtil.drawRect(this.grabber, grabColor);
        }
    }

    public void handleMouseInput() {
        int scrollDelta = Mouse.getEventDWheel();
        if (this.canScroll() && !this.isScrolling() && scrollDelta != 0) {
            this.setScroll(this.scroll - (scrollDelta > 0 ? 20 : -20));
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int button) {
        if (this.canScroll() && !this.isScrolling() && this.bounds.contains(mouseX, mouseY)) {
            this.clickOffset = this.grabber.contains(mouseX, mouseY) ? mouseY - this.grabber.getTop() : this.grabber.getHeight() / 2;
            this.mouseClickMove(mouseX, mouseY, button, 0L);
        }
    }

    protected void mouseClickMove(int mouseX, int mouseY, int button, long heldTime) {
        if (this.isScrolling()) {
            this.setScroll((int)((float)(mouseY - this.bounds.getY() - this.clickOffset) / this.scaleFactor));
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int button) {
        this.clickOffset = -1;
    }
}

