/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.gui;

import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.gui.GuiActionButton;
import jobicade.betterhud.gui.GuiHudMenu;
import jobicade.betterhud.util.GlUtil;
import jobicade.betterhud.util.SortField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

class SortButton
extends GuiActionButton {
    private static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("textures/gui/resource_packs.png");
    private static final Rect UP_TEXTURE = new Rect(114, 5, 11, 7);
    private static final Rect DOWN_TEXTURE = new Rect(82, 20, 11, 7);
    private final GuiHudMenu callback;
    SortField<HudElement> sortValue;

    SortButton(GuiHudMenu callback, SortField<HudElement> sortValue) {
        super(I18n.func_135052_a((String)sortValue.getUnlocalizedName(), (Object[])new Object[0]));
        this.callback = callback;
        this.sortValue = sortValue;
        this.setCallback(b -> callback.changeSort(sortValue));
    }

    private boolean isTargeted() {
        return this.callback.getSortCriteria() == this.sortValue;
    }

    @Override
    protected int func_146114_a(boolean mouseOver) {
        return this.isTargeted() ? 2 : super.func_146114_a(mouseOver);
    }

    @Override
    protected void drawButton(Rect bounds, Point mousePosition, float partialTicks) {
        super.drawButton(bounds, mousePosition, partialTicks);
        if (this.isTargeted()) {
            Rect texture = this.callback.isDescending() ? DOWN_TEXTURE : UP_TEXTURE;
            Rect arrow = new Rect(texture).anchor(bounds, Direction.EAST).translate(-2, 0);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ARROW_TEXTURE);
            GlUtil.drawRect(arrow, texture);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(field_110324_m);
        }
    }
}

