/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.proxy;

import java.nio.file.Path;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.config.ConfigManager;
import jobicade.betterhud.config.HudConfig;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.events.RenderEvents;
import jobicade.betterhud.gui.GuiHudMenu;
import jobicade.betterhud.proxy.HudSidedProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;

public class ClientProxy
implements HudSidedProxy {
    private ConfigManager configManager;
    private KeyBinding menuKey = new KeyBinding("key.betterHud.open", 22, "key.categories.misc");

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Path configPath = event.getSuggestedConfigurationFile().toPath();
        HudElement.loadAllDefaults();
        this.configManager = new ConfigManager(configPath, configPath.resolveSibling("betterhud"));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            IReloadableResourceManager reloadableManager = (IReloadableResourceManager)manager;
            reloadableManager.func_110542_a(m -> HudElement.SORTER.markDirty(HudElement.SortType.ALPHABETICAL));
            reloadableManager.func_110542_a((IResourceManagerReloadListener)this.configManager);
        } else {
            BetterHud.getLogger().warn("Unable to register alphabetical sort update on language change");
        }
        ClientRegistry.registerKeyBinding((KeyBinding)this.menuKey);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        HudElement.initAll(event);
    }

    @Override
    public boolean isModEnabled() {
        return HudElement.GLOBAL.isEnabledAndSupported() && (!HudElement.GLOBAL.hideOnDebug() || !Minecraft.func_71410_x().field_71474_y.field_74330_P);
    }

    @Override
    public HudConfig getConfig() {
        return this.configManager.getConfig();
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71415_G && this.menuKey.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiHudMenu(this.configManager));
        }
    }
}

