/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.render;

import java.util.Arrays;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class Color {
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color GRAY = new Color(127, 127, 127);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color BLUE = new Color(0, 0, 255);
    public static final Color TRANSLUCENT = new Color(95, 0, 0, 0);
    public static final Color FOREGROUND = new Color(127, 63, 63, 63);
    public static final Color HIGHLIGHT = new Color(191, 63, 63, 63);
    private final int alpha;
    private final int red;
    private final int green;
    private final int blue;
    private final int packed;

    public Color(int red, int green, int blue) {
        this(255, red, green, blue);
    }

    public Color(int alpha, int red, int green, int blue) {
        this.alpha = MathHelper.func_76125_a((int)alpha, (int)0, (int)255);
        this.red = MathHelper.func_76125_a((int)red, (int)0, (int)255);
        this.green = MathHelper.func_76125_a((int)green, (int)0, (int)255);
        this.blue = MathHelper.func_76125_a((int)blue, (int)0, (int)255);
        this.packed = this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue;
    }

    public Color(int packed) {
        this.alpha = packed >> 24;
        this.red = packed >> 16 & 0xFF;
        this.green = packed >> 8 & 0xFF;
        this.blue = packed & 0xFF;
        this.packed = packed;
    }

    public int getPacked() {
        return this.packed;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public Color withAlpha(int alpha) {
        return new Color(alpha, this.red, this.green, this.blue);
    }

    public Color withRed(int red) {
        return new Color(this.alpha, red, this.green, this.blue);
    }

    public Color withGreen(int green) {
        return new Color(this.alpha, this.red, green, this.blue);
    }

    public Color withBlue(int blue) {
        return new Color(this.alpha, this.red, this.green, blue);
    }

    public void apply() {
        GlStateManager.func_179131_c((float)((float)this.red / 255.0f), (float)((float)this.green / 255.0f), (float)((float)this.blue / 255.0f), (float)((float)this.alpha / 255.0f));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Color)) {
            return false;
        }
        Color color = (Color)obj;
        return this.red == color.red && this.green == color.green && this.blue == color.blue && this.alpha == color.alpha;
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.red, this.green, this.blue, this.alpha});
    }

    public String toString() {
        return String.format("{rgba: %d, %d, %d, %d}", this.red, this.green, this.blue, this.alpha);
    }

    public static Color fromHSV(float hue, float saturation, float value) {
        hue -= (float)MathHelper.func_76141_d((float)hue);
        saturation = MathHelper.func_76131_a((float)saturation, (float)0.0f, (float)1.0f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        return new Color(MathHelper.func_181758_c((float)hue, (float)saturation, (float)value)).withAlpha(255);
    }

    public static Color getProgressColor(float progress) {
        progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        return Color.fromHSV(progress / 3.0f, 1.0f, 1.0f);
    }
}

