/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.render;

import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import jobicade.betterhud.render.Color;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GlSnapshot {
    private final Map<Flag, Boolean> flags = new EnumMap<Flag, Boolean>(Flag.class);
    private final Color color;
    private final int texture;
    private final BlendFunc blendFunc;

    public GlSnapshot() {
        for (Flag flag : Flag.values()) {
            this.flags.put(flag, flag.isEnabled());
        }
        this.color = this.getCurrentColor();
        this.texture = this.getCurrentTexture();
        this.blendFunc = this.getCurrentBlendFunc();
    }

    private Color getCurrentColor() {
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2816, (FloatBuffer)buf);
        int red = Math.round(buf.get(0) * 255.0f);
        int green = Math.round(buf.get(1) * 255.0f);
        int blue = Math.round(buf.get(2) * 255.0f);
        int alpha = Math.round(buf.get(3) * 255.0f);
        return new Color(alpha, red, green, blue);
    }

    private int getCurrentTexture() {
        return GL11.glGetInteger((int)32873);
    }

    private BlendFunc getCurrentBlendFunc() {
        int srcFactor = GL11.glGetInteger((int)32969);
        int dstFactor = GL11.glGetInteger((int)32968);
        int srcFactorAlpha = GL11.glGetInteger((int)32971);
        int dstFactorAlpha = GL11.glGetInteger((int)32970);
        return new BlendFunc(srcFactor, dstFactor, srcFactorAlpha, dstFactorAlpha);
    }

    public Map<Flag, Boolean> getFlags() {
        return Collections.unmodifiableMap(this.flags);
    }

    public Color getColor() {
        return this.color;
    }

    public int getTexture() {
        return this.texture;
    }

    public BlendFunc getBlendFunc() {
        return this.blendFunc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GlSnapshot)) {
            return false;
        }
        GlSnapshot snapshot = (GlSnapshot)obj;
        return this.flags.equals(snapshot.flags) && this.color.equals(snapshot.color) && this.texture == snapshot.texture && this.blendFunc.equals(snapshot.blendFunc);
    }

    public int hashCode() {
        return Objects.hash(this.flags, this.color, this.texture, this.blendFunc);
    }

    public String toString() {
        return String.format("{flags: %s, color: %s, texture: %d, blendfunc: %s}", this.flags, this.color, this.texture, this.blendFunc);
    }

    public static enum Flag {
        ALPHA_TEST(3008),
        BLEND(3042),
        DEPTH_TEST(2929),
        LIGHTING(2896),
        TEXTURE_2D(3553),
        COLOR_MATERIAL(2903),
        RESCALE_NORMAL(32826),
        LIGHT_0(16384),
        LIGHT_1(16385),
        LIGHT_2(16386),
        LIGHT_3(16387),
        LIGHT_4(16388),
        LIGHT_5(16389),
        LIGHT_6(16390),
        LIGHT_7(16391);

        private final int code;

        private Flag(int code) {
            this.code = code;
        }

        public boolean isEnabled() {
            return GL11.glIsEnabled((int)this.code);
        }
    }

    public static class BlendFunc {
        private final GlStateManager.SourceFactor srcFactor;
        private final GlStateManager.DestFactor dstFactor;
        private final GlStateManager.SourceFactor srcFactorAlpha;
        private final GlStateManager.DestFactor dstFactorAlpha;

        private BlendFunc(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
            this(BlendFunc.getSrcFactor(srcFactor), BlendFunc.getDstFactor(dstFactor), BlendFunc.getSrcFactor(srcFactorAlpha), BlendFunc.getDstFactor(dstFactorAlpha));
        }

        private BlendFunc(GlStateManager.SourceFactor srcFactor, GlStateManager.DestFactor dstFactor, GlStateManager.SourceFactor srcFactorAlpha, GlStateManager.DestFactor dstFactorAlpha) {
            this.srcFactor = srcFactor;
            this.dstFactor = dstFactor;
            this.srcFactorAlpha = srcFactorAlpha;
            this.dstFactorAlpha = dstFactorAlpha;
        }

        private static GlStateManager.SourceFactor getSrcFactor(int factor) {
            for (GlStateManager.SourceFactor srcFactor : GlStateManager.SourceFactor.values()) {
                if (srcFactor.field_187395_p != factor) continue;
                return srcFactor;
            }
            return null;
        }

        private static GlStateManager.DestFactor getDstFactor(int factor) {
            for (GlStateManager.DestFactor dstFactor : GlStateManager.DestFactor.values()) {
                if (dstFactor.field_187345_o != factor) continue;
                return dstFactor;
            }
            return null;
        }

        public GlStateManager.SourceFactor getSrcFactor() {
            return this.srcFactor;
        }

        public GlStateManager.DestFactor getDstFactor() {
            return this.dstFactor;
        }

        public GlStateManager.SourceFactor getSrcFactorAlpha() {
            return this.srcFactorAlpha;
        }

        public GlStateManager.DestFactor getDstFactorAlpha() {
            return this.dstFactorAlpha;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BlendFunc)) {
                return false;
            }
            BlendFunc blendFunc = (BlendFunc)obj;
            return this.srcFactor == blendFunc.srcFactor && this.dstFactor == blendFunc.dstFactor && this.srcFactorAlpha == blendFunc.srcFactorAlpha && this.dstFactorAlpha == blendFunc.dstFactorAlpha;
        }

        public int hashCode() {
            return Objects.hash(this.srcFactor, this.dstFactor, this.srcFactorAlpha, this.dstFactorAlpha);
        }

        public String toString() {
            return String.format("{src: %s, dst: %s, srcAlpha: %s, dstAlpha: %s}", this.srcFactor, this.dstFactor, this.srcFactorAlpha, this.dstFactorAlpha);
        }
    }
}

