/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.render.Boxed;
import jobicade.betterhud.render.DefaultBoxed;

public class Grid<T extends Boxed>
extends DefaultBoxed {
    private List<T> source;
    private Rect shape;
    private Size gutter = Size.zero();
    private boolean stretch = false;
    private Direction alignment = Direction.NORTH_WEST;
    private Direction cellAlignment = Direction.CENTER;

    public Grid(Point shape) {
        this(shape, new ArrayList<Object>(Collections.nCopies(shape.getX() * shape.getY(), null)));
    }

    public Grid(Point shape, List<T> source) {
        this.shape = new Rect(shape);
        this.source = source;
    }

    public Grid<T> setSource(List<T> source) {
        this.source = source;
        return this;
    }

    public List<T> getSource() {
        return this.source;
    }

    public List<T> flatten() {
        return this.source.subList(0, this.shape.getWidth() * this.shape.getHeight());
    }

    public T getCell(Point position) {
        return (T)((Boxed)this.source.get(this.getCellIndex(position)));
    }

    public Grid<T> setCell(Point position, T element) {
        this.source.set(this.getCellIndex(position), element);
        return this;
    }

    private int getCellIndex(Point position) {
        if (!this.shape.contains(position)) {
            throw new IndexOutOfBoundsException("Grid coordinates " + position);
        }
        return position.getY() * this.shape.getWidth() + position.getX();
    }

    public Rect getCellBounds(Rect bounds, Point position) {
        Size gutterless = bounds.getSize().sub(this.shape.getSize().sub(1, 1).scale(this.gutter));
        Size cellSize = gutterless.scale(1.0f / (float)this.shape.getWidth(), 1.0f / (float)this.shape.getHeight());
        Direction flow = this.alignment.mirror();
        Point offset = new Point((flow.getCol() - 1) * position.getX(), (flow.getRow() - 1) * position.getY()).scale(cellSize.add(this.gutter));
        return new Rect(cellSize).anchor(bounds, this.alignment).translate(offset);
    }

    public Size getGutter() {
        return this.gutter;
    }

    public Grid<T> setGutter(Point gutter) {
        this.gutter = gutter instanceof Size ? (Size)gutter : new Size(gutter);
        return this;
    }

    public boolean hasStretch() {
        return this.stretch;
    }

    public Grid<T> setStretch(boolean stretch) {
        this.stretch = stretch;
        return this;
    }

    public Direction getAlignment() {
        return this.alignment;
    }

    public Grid<T> setAlignment(Direction alignment) {
        if (!DirectionOptions.CORNERS.isValid(alignment)) {
            throw new IllegalArgumentException("Grid alignment must be a corner");
        }
        this.alignment = alignment;
        return this;
    }

    public Direction getCellAlignment() {
        return this.cellAlignment;
    }

    public Grid<T> setCellAlignment(Direction cellAlignment) {
        this.cellAlignment = cellAlignment;
        return this;
    }

    @Override
    public Size getPreferredSize() {
        if (this.shape.isEmpty()) {
            return Size.zero();
        }
        int width = 0;
        int height = 0;
        for (Boxed element : this.flatten()) {
            if (element == null) continue;
            Size size = element.getPreferredSize();
            if (size.getWidth() > width) {
                width = size.getWidth();
            }
            if (size.getHeight() <= height) continue;
            height = size.getHeight();
        }
        return this.shape.getSize().scale(width, height).add(this.shape.getSize().sub(1, 1).scale(this.gutter));
    }

    @Override
    public void render() {
        Rect cellLeft;
        int x = 0;
        Size gutterless = this.bounds.getSize().sub(this.shape.getSize().sub(1, 1).scale(this.gutter));
        Size cellSize = gutterless.scale(1.0f / (float)this.shape.getWidth(), 1.0f / (float)this.shape.getHeight());
        Rect cell = cellLeft = new Rect(cellSize).anchor(this.bounds, this.alignment);
        Rect gutterPadding = new Rect((Point)this.gutter.invert(), new Point(this.gutter));
        Direction flow = this.alignment.mirror();
        for (Boxed element : this.flatten()) {
            if (element != null) {
                Size size = this.stretch ? element.negotiateSize(cell.getSize()) : element.getPreferredSize();
                element.setBounds(new Rect(size).anchor(cell, this.cellAlignment)).render();
            }
            if (x >= this.shape.getWidth() - 1) {
                x = 0;
                cell = cellLeft = cellLeft.anchor(cellLeft.grow(gutterPadding), flow.withCol(1), true);
                continue;
            }
            ++x;
            cell = cell.anchor(cell.grow(gutterPadding), flow.withRow(1), true);
        }
    }
}

