/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.render;

import java.util.EnumMap;
import java.util.Map;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.DefaultBoxed;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class Quad
extends DefaultBoxed {
    private static final float TEX_SCALE = 0.00390625f;
    private double zLevel;
    private Rect texture;
    private final Map<Direction, Color> colors;
    private boolean hasColor = false;

    public Quad() {
        this.colors = new EnumMap<Direction, Color>(Direction.class);
    }

    public Quad(Quad quad) {
        this.colors = new EnumMap<Direction, Color>(quad.colors);
        this.hasColor = quad.hasColor;
        this.setZLevel(quad.zLevel);
        this.setTexture(quad.texture);
    }

    public Quad setZLevel(double zLevel) {
        this.zLevel = zLevel;
        return this;
    }

    public Quad setTexture(Rect texture) {
        this.texture = texture;
        return this;
    }

    public Quad setColor(Color color) {
        this.setColors(color, color, color, color);
        return this;
    }

    public Quad setColor(Direction direction, Color color) {
        this.colors.put(direction, color);
        this.hasColor = true;
        return this;
    }

    public Quad setColors(Color northWest, Color northEast, Color southWest, Color southEast) {
        this.colors.put(Direction.NORTH_WEST, northWest);
        this.colors.put(Direction.NORTH_EAST, northEast);
        this.colors.put(Direction.SOUTH_WEST, southWest);
        this.colors.put(Direction.SOUTH_EAST, southEast);
        this.hasColor = true;
        return this;
    }

    public Quad noColor() {
        this.hasColor = false;
        return this;
    }

    @Override
    public void render() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        VertexFormat format = new VertexFormat();
        format.func_181721_a(DefaultVertexFormats.field_181713_m);
        if (this.texture != null) {
            format.func_181721_a(DefaultVertexFormats.field_181715_o);
        }
        if (this.hasColor) {
            format.func_181721_a(DefaultVertexFormats.field_181714_n);
        }
        builder.func_181668_a(7, format);
        this.addVertex(this.bounds, builder, Direction.SOUTH_WEST);
        this.addVertex(this.bounds, builder, Direction.SOUTH_EAST);
        this.addVertex(this.bounds, builder, Direction.NORTH_EAST);
        this.addVertex(this.bounds, builder, Direction.NORTH_WEST);
        if (this.texture == null) {
            GlStateManager.func_179090_x();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
        } else {
            tessellator.func_78381_a();
        }
    }

    private void addVertex(Rect bounds, BufferBuilder builder, Direction anchor) {
        block5: for (VertexFormatElement element : builder.func_178973_g().func_177343_g()) {
            switch (element.func_177375_c()) {
                case POSITION: {
                    Point xy = bounds.getAnchor(anchor);
                    builder.func_181662_b((double)xy.getX(), (double)xy.getY(), this.zLevel);
                    continue block5;
                }
                case UV: {
                    Point uv = this.texture.getAnchor(anchor);
                    builder.func_187315_a((double)((float)uv.getX() * 0.00390625f), (double)((float)uv.getY() * 0.00390625f));
                    continue block5;
                }
                case COLOR: {
                    Color color = this.colors.get((Object)anchor);
                    builder.func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                    continue block5;
                }
            }
            throw new IllegalStateException("Unsupported builder element");
        }
        builder.func_181675_d();
    }

    @Override
    public Size getPreferredSize() {
        return this.texture != null ? this.texture.getSize() : Size.zero();
    }
}

