/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.util;

import java.util.EnumSet;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.render.Quad;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public final class GlUtil {
    private GlUtil() {
    }

    public static void scale(float scale) {
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
    }

    public static void drawRect(Rect bounds, Color color) {
        new Quad().setColor(color).setBounds(bounds).render();
    }

    public static void drawRect(Rect bounds, Rect texture) {
        new Quad().setTexture(texture).setBounds(bounds).render();
    }

    public static void drawRect(Rect bounds, Rect texture, Color color) {
        new Quad().setTexture(texture).setColor(color).setBounds(bounds).render();
    }

    public static void drawBorderRect(Rect bounds, Color color) {
        Quad quad = new Quad().setColor(color);
        quad.setBounds(bounds.withWidth(1)).render();
        quad.setBounds(bounds.withHeight(1)).render();
        quad.setBounds(bounds.withLeft(bounds.getRight() - 1)).render();
        quad.setBounds(bounds.withTop(bounds.getBottom() - 1)).render();
    }

    public static void drawBorderedString(String text, int x, int y, Color color) {
        Minecraft.func_71410_x().field_71466_p.func_175065_a(text, (float)(x + 1), (float)y, Color.BLACK.getPacked(), false);
        Minecraft.func_71410_x().field_71466_p.func_175065_a(text, (float)(x - 1), (float)y, Color.BLACK.getPacked(), false);
        Minecraft.func_71410_x().field_71466_p.func_175065_a(text, (float)x, (float)(y + 1), Color.BLACK.getPacked(), false);
        Minecraft.func_71410_x().field_71466_p.func_175065_a(text, (float)x, (float)(y - 1), Color.BLACK.getPacked(), false);
        Minecraft.func_71410_x().field_71466_p.func_175065_a(text, (float)x, (float)y, color.getPacked(), false);
        Color.WHITE.apply();
        GlStateManager.func_179118_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static void renderSingleItem(ItemStack stack, Point point) {
        GlUtil.renderSingleItem(stack, point.getX(), point.getY());
    }

    public static void renderSingleItem(ItemStack stack, int x, int y) {
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, x, y);
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        GlUtil.blendFuncSafe(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
        GlStateManager.func_179103_j((int)7425);
    }

    public static void renderHotbarItem(Rect bounds, ItemStack stack, float partialTicks) {
        if (stack.func_190926_b()) {
            return;
        }
        float animationTicks = (float)stack.func_190921_D() - partialTicks;
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        if (animationTicks > 0.0f) {
            float factor = 1.0f + animationTicks / 5.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(bounds.getX() + 8), (float)(bounds.getY() + 12), (float)0.0f);
            GlStateManager.func_179152_a((float)(1.0f / factor), (float)((factor + 1.0f) / 2.0f), (float)1.0f);
            GlStateManager.func_179109_b((float)(-(bounds.getX() + 8)), (float)(-(bounds.getY() + 12)), (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, stack, bounds.getX(), bounds.getY());
            GlStateManager.func_179121_F();
        } else {
            Minecraft.func_71410_x().func_175599_af().func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, stack, bounds.getX(), bounds.getY());
        }
        Minecraft.func_71410_x().func_175599_af().func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, bounds.getX(), bounds.getY());
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        GlUtil.blendFuncSafe(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
        GlStateManager.func_179103_j((int)7425);
    }

    public static void drawTooltipBox(Rect bounds) {
        Color background = new Color(183, 16, 0, 16);
        Color borderTop = new Color(80, 80, 0, 255);
        Color borderBottom = new Color(80, 40, 0, 127);
        Quad quad = new Quad().setZLevel(300.0);
        quad.setColor(background);
        quad.setBounds(bounds.withHeight(1).grow(-1, 0, -1, 0)).render();
        quad.setBounds(bounds.grow(0, -1, 0, -1)).render();
        quad.setBounds(bounds.withTop(bounds.getBottom() - 1).grow(-1, 0, -1, 0)).render();
        Rect inner = bounds.grow(-1);
        quad.setColor(borderTop).setBounds(inner.withHeight(1)).render();
        quad.setColor(borderBottom).setBounds(inner.withTop(inner.getBottom() - 1)).render();
        inner = inner.grow(0, -1, 0, -1);
        quad.setColors(borderTop, borderTop, borderBottom, borderBottom);
        quad.setBounds(inner.withWidth(1)).render();
        quad.setBounds(inner.withLeft(inner.getRight() - 1)).render();
    }

    public static void setupBillboard(Entity entity, float partialTicks, float scaleFactor) {
        double dx = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks - (Minecraft.func_71410_x().field_71439_g.field_70169_q + (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70169_q) * (double)partialTicks);
        double dy = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks - (Minecraft.func_71410_x().field_71439_g.field_70167_r + (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70167_r) * (double)partialTicks);
        double dz = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks - (Minecraft.func_71410_x().field_71439_g.field_70166_s + (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70166_s) * (double)partialTicks);
        GlStateManager.func_179137_b((double)dx, (double)(dy += (double)entity.field_70131_O + 0.5), (double)dz);
        float distance = (float)Math.sqrt(dx * dx + (dy -= (double)Minecraft.func_71410_x().field_71439_g.func_70047_e()) * dy + dz * dz);
        GlUtil.scale(distance * (scaleFactor + 0.5f) / 300.0f);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().field_71439_g.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().field_71439_g.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static void drawDamageBar(Rect bounds, ItemStack stack, boolean vertical) {
        float progress = (float)(stack.func_77958_k() - stack.func_77952_i()) / (float)stack.func_77958_k();
        GlUtil.drawProgressBar(bounds, progress, vertical);
    }

    public static void drawProgressBar(Rect bounds, float progress, boolean vertical) {
        Rect bar;
        GlUtil.drawRect(bounds, Color.BLACK);
        progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        Color color = Color.fromHSV(progress / 3.0f, 1.0f, 1.0f);
        if (vertical) {
            bar = new Rect(bounds.getWidth() - 1, (int)(progress * (float)bounds.getHeight()));
            bar = bar.anchor(bounds, Direction.SOUTH_WEST);
        } else {
            bar = new Rect((int)(progress * (float)bounds.getWidth()), bounds.getHeight() - 1);
            bar = bar.anchor(bounds, Direction.NORTH_WEST);
        }
        GlUtil.drawRect(bar, color);
    }

    public static void drawTexturedProgressBar(Point position, Rect background, Rect foreground, float progress, Direction direction) {
        int partial;
        GlUtil.drawRect(background.move(position), background);
        Rect bounds = background.move(position);
        Rect partialRect = new Rect(bounds);
        Rect partialForeground = new Rect(foreground);
        if (!DirectionOptions.VERTICAL.isValid(direction)) {
            partial = MathHelper.func_76123_f((float)(progress * (float)partialRect.getWidth()));
            partialRect = partialRect.withWidth(partial);
            partialForeground = partialForeground.withWidth(partial);
        } else {
            partial = MathHelper.func_76123_f((float)(progress * (float)partialRect.getHeight()));
            partialRect = partialRect.withHeight(partial);
            partialForeground = partialForeground.withHeight(partial);
        }
        Direction anchor = direction.mirror();
        partialRect = partialRect.anchor(bounds, anchor);
        partialForeground = partialForeground.anchor(foreground, anchor);
        GlUtil.drawRect(partialRect, partialForeground);
    }

    public static Point getStringSize(String string) {
        return new Point(Minecraft.func_71410_x().field_71466_p.func_78256_a(string), Minecraft.func_71410_x().field_71466_p.field_78288_b);
    }

    public static Rect drawString(String string, Point origin, Direction alignment, Color color) {
        Label label = new Label(string).setColor(color);
        Rect bounds = new Rect(label.getPreferredSize()).align(origin, alignment);
        label.setBounds(bounds).render();
        return bounds;
    }

    public static void blendFuncSafe(GlStateManager.SourceFactor srcFactor, GlStateManager.DestFactor dstFactor, GlStateManager.SourceFactor srcFactorAlpha, GlStateManager.DestFactor dstFactorAlpha) {
        EnumSet<GlStateManager.SourceFactor> factors = EnumSet.allOf(GlStateManager.SourceFactor.class);
        factors.remove(srcFactor);
        factors.removeIf(f -> f.field_187395_p == GL11.glGetInteger((int)3041));
        GlStateManager.SourceFactor dummyFactor = (GlStateManager.SourceFactor)factors.iterator().next();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)dummyFactor, (GlStateManager.DestFactor)dstFactor, (GlStateManager.SourceFactor)srcFactorAlpha, (GlStateManager.DestFactor)dstFactorAlpha);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)srcFactor, (GlStateManager.DestFactor)dstFactor, (GlStateManager.SourceFactor)srcFactorAlpha, (GlStateManager.DestFactor)dstFactorAlpha);
    }

    public static void beginScissor(Rect scissorRect, ScaledResolution resolution) {
        Rect scaledRect = scissorRect.withY(resolution.func_78328_b() - scissorRect.getBottom()).scale(resolution.func_78325_e());
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scaledRect.getX(), (int)scaledRect.getY(), (int)scaledRect.getWidth(), (int)scaledRect.getHeight());
    }

    public static void endScissor() {
        GL11.glDisable((int)3089);
    }
}

