/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.util;

import java.util.List;

public class Paginator<T> {
    private List<T> data;
    private int pageOffset;
    private int pageSize;

    public void setData(List<T> data) {
        this.data = data;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageIndex() {
        return this.pageOffset / this.pageSize;
    }

    public int getPageCount() {
        return (this.data.size() + this.pageSize - 1) / this.pageSize;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List<T> getData() {
        return this.data;
    }

    public List<T> getPage() {
        return this.data.subList(this.getLow(), this.getHigh());
    }

    public int getLow() {
        return this.getPageIndex() * this.pageSize;
    }

    public int getHigh() {
        return Math.min(this.data.size(), (this.getPageIndex() + 1) * this.pageSize);
    }

    public void setPage(int page) {
        this.pageOffset = page * this.pageSize;
    }

    public boolean hasPrevious() {
        return this.getPageIndex() > 0;
    }

    public boolean hasNext() {
        return this.getPageIndex() < this.getPageCount() - 1;
    }

    public boolean previousPage() {
        if (this.hasPrevious()) {
            this.setPage(this.getPageIndex() - 1);
            return true;
        }
        return false;
    }

    public boolean nextPage() {
        if (this.hasNext()) {
            this.setPage(this.getPageIndex() + 1);
            return true;
        }
        return false;
    }
}

