/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.util;

import java.util.ArrayList;
import jobicade.betterhud.BetterHud;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public interface Tickable {
    public void tick();

    public static enum Ticker implements Tickable
    {
        FASTER(1),
        FAST(20),
        MEDIUM(5),
        SLOW(2);

        private Ticker next;
        private ArrayList<Tickable> children = new ArrayList();
        private final int ticks;
        private int counter = 0;

        private Ticker(int ticks) {
            this.ticks = ticks;
        }

        public void register(Tickable element) {
            this.children.add(element);
        }

        @Override
        public void tick() {
            if (++this.counter >= this.ticks) {
                for (Tickable element : this.children) {
                    element.tick();
                }
                this.counter = 0;
                if (this.next != null) {
                    this.next.tick();
                }
            }
        }

        public static void startTick() {
            FASTER.tick();
        }

        public static void registerEvents() {
            MinecraftForge.EVENT_BUS.register((Object)FASTER);
        }

        @SubscribeEvent
        public void clientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && BetterHud.getProxy().isModEnabled()) {
                Ticker.startTick();
            }
        }

        static {
            for (int i = 0; i < Ticker.values().length - 1; ++i) {
                Ticker.values()[i].next = Ticker.values()[i + 1];
            }
        }
    }
}

