/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.util.bars;

import java.util.List;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.DefaultBoxed;
import jobicade.betterhud.util.GlUtil;
import jobicade.betterhud.util.MathUtil;

public abstract class StatBar<T>
extends DefaultBoxed {
    protected T host;
    protected Direction contentAlignment = Direction.NORTH_WEST;

    protected int getMaximum() {
        return 20;
    }

    public void setHost(T host) {
        this.host = host;
    }

    public Direction getContentAlignment() {
        return this.contentAlignment;
    }

    public StatBar<T> setContentAlignment(Direction contentAlignment) {
        this.contentAlignment = contentAlignment;
        return this;
    }

    protected boolean shouldCompress() {
        return false;
    }

    protected abstract List<Rect> getIcons(int var1);

    public boolean shouldRender() {
        return true;
    }

    protected int getIconBounce(int pointsIndex) {
        return 0;
    }

    protected int getRowSpacing() {
        return this.getIconSize();
    }

    protected int getIconSize() {
        return 9;
    }

    protected int getRowPoints() {
        return 20;
    }

    protected Direction getNativeAlignment() {
        return null;
    }

    @Override
    public void render() {
        if (!DirectionOptions.CORNERS.isValid(this.contentAlignment)) {
            throw new IllegalArgumentException("Bar must start in a corner");
        }
        Direction columnWise = this.contentAlignment.withRow(1).mirrorCol();
        Rect icon = new Rect(this.getIconSize(), this.getIconSize()).anchor(this.bounds, this.contentAlignment);
        Rect rowReturn = new Rect(icon);
        int max = this.getMaximum();
        int rowPoints = this.getRowPoints();
        int rowSpacing = this.getRowSpacing();
        if (this.contentAlignment.getRow() == 2) {
            rowSpacing = -rowSpacing;
        }
        int i = 0;
        Point textPosition = null;
        String text = null;
        if (this.shouldCompress()) {
            int rows = (max - 1) / rowPoints;
            i = rows * rowPoints;
            int x = 0;
            while (x < rowPoints) {
                this.drawIcon(x, icon, this.contentAlignment);
                x += 2;
                icon = icon.align(icon.getAnchor(Direction.CENTER), columnWise.mirrorCol());
            }
            textPosition = icon.getAnchor(columnWise);
            text = "x" + rows;
            icon = rowReturn = rowReturn.translate(0, rowSpacing);
        }
        while (i < max) {
            int x = 0;
            while (x < rowPoints && i < max) {
                this.drawIcon(i, icon, this.contentAlignment);
                i += 2;
                x += 2;
                icon = icon.anchor(icon.grow(-1), columnWise, true);
            }
            icon = rowReturn = rowReturn.translate(0, rowSpacing);
        }
        if (text != null) {
            GlUtil.drawString(text, textPosition, columnWise.mirrorCol(), Color.WHITE);
        }
    }

    protected void drawIcon(int i, Rect bounds, Direction contentAlignment) {
        bounds = bounds.translate(0, this.getIconBounce(i));
        for (Rect texture : this.getIcons(i)) {
            if (texture == null) continue;
            texture = this.ensureNative(texture, contentAlignment.withRow(1));
            GlUtil.drawRect(bounds, texture);
        }
    }

    protected Rect ensureNative(Rect texture, Direction alignment) {
        Direction nativeAlignment = this.getNativeAlignment();
        if (nativeAlignment != null && nativeAlignment != alignment) {
            return texture.scale(-1.0f, 1.0f).withX(texture.getRight());
        }
        return texture;
    }

    @Override
    public Size negotiateSize(Point size) {
        int rowPoints = this.getRowPoints();
        Size rowSize = new Size((this.getIconSize() - 1) * MathUtil.ceilDiv(rowPoints, 2) + 1, this.getIconSize());
        int rows = this.shouldCompress() ? 2 : MathUtil.ceilDiv(this.getMaximum(), rowPoints);
        return rowSize.add(0, (rows - 1) * this.getRowSpacing());
    }
}

