/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.util.bars;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.util.MathUtil;
import jobicade.betterhud.util.bars.StatBar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;

public class StatBarHealth
extends StatBar<EntityLivingBase> {
    private final Random random = new Random();
    private int currentHealth;
    private int displayHealth;
    private int maxHealth;
    private int absorptionHealth;
    private int flash;
    private int currentUpdateCounter;
    private int regenCounter;
    private int compressThreshold = -1;

    @Override
    public void setHost(EntityLivingBase host) {
        if (this.host != host) {
            this.currentHealth = 0;
        }
        super.setHost(host);
    }

    @Override
    public Direction getNativeAlignment() {
        return Direction.WEST;
    }

    @Override
    protected int getIconBounce(int pointsIndex) {
        int bounce = 0;
        if (this.currentHealth <= MathUtil.ceilDiv(this.maxHealth, 5)) {
            bounce += this.random.nextInt(2);
        }
        if (this.regenCounter == pointsIndex) {
            bounce -= 2;
        }
        return bounce;
    }

    public void setCompressThreshold(int compressThreshold) {
        this.compressThreshold = compressThreshold;
    }

    @Override
    protected boolean shouldCompress() {
        return this.compressThreshold > 0 && this.currentHealth > this.compressThreshold;
    }

    @Override
    protected int getMaximum() {
        int maximum = MathUtil.ceil(this.maxHealth, 2) + this.absorptionHealth;
        if (this.shouldCompress()) {
            return Math.min(MathUtil.ceil(this.currentHealth, this.getRowPoints()), maximum);
        }
        if (this.compressThreshold > 0) {
            return Math.min(maximum, this.compressThreshold);
        }
        return maximum;
    }

    @Override
    protected int getRowSpacing() {
        return this.shouldCompress() ? super.getRowSpacing() : Math.max(10 - (MathUtil.ceilDiv(this.getMaximum(), 20) - 2), 3);
    }

    @Override
    protected List<Rect> getIcons(int pointsIndex) {
        int y;
        ArrayList<Rect> icons = new ArrayList<Rect>(3);
        int fullX = pointsIndex >= this.maxHealth ? 160 : (((EntityLivingBase)this.host).func_70644_a(MobEffects.field_76436_u) ? 88 : (((EntityLivingBase)this.host).func_70644_a(MobEffects.field_82731_v) ? 124 : 52));
        int n = y = ((EntityLivingBase)this.host).func_130014_f_().func_72912_H().func_76093_s() ? 45 : 0;
        if (this.flash % 6 >= 3) {
            icons.add(new Rect(25, y, 9, 9));
            if (pointsIndex + 1 >= this.currentHealth && pointsIndex < this.displayHealth) {
                icons.add(new Rect(pointsIndex + 1 < this.displayHealth ? fullX + 18 : fullX + 27, y, 9, 9));
            }
        } else {
            icons.add(new Rect(16, y, 9, 9));
        }
        if (pointsIndex < this.currentHealth) {
            icons.add(new Rect(pointsIndex + 1 < this.currentHealth ? fullX : fullX + 9, y, 9, 9));
        } else if (pointsIndex >= this.maxHealth) {
            icons.add(new Rect(pointsIndex + 1 < this.getMaximum() ? fullX : fullX + 9, y, 9, 9));
        }
        return icons;
    }

    @Override
    public void render() {
        int newUpdateCounter = Minecraft.func_71410_x().field_71456_v.func_73834_c();
        int updateDelta = newUpdateCounter - this.currentUpdateCounter;
        this.random.setSeed(newUpdateCounter);
        this.maxHealth = MathUtil.getHealthForDisplay(((EntityLivingBase)this.host).func_110138_aP());
        this.absorptionHealth = MathUtil.getHealthForDisplay(((EntityLivingBase)this.host).func_110139_bj());
        int newHealth = MathUtil.getHealthForDisplay(((EntityLivingBase)this.host).func_110143_aJ());
        if (this.currentHealth <= 0 && newHealth > 0) {
            this.displayHealth = newHealth;
            this.flash = 0;
        } else if (this.currentHealth != newHealth) {
            if (newHealth < this.displayHealth) {
                this.flash = 17;
            } else {
                if (this.flash < 11) {
                    this.flash = 11;
                }
                this.displayHealth = newHealth;
            }
        } else if (this.flash > 0) {
            this.flash -= updateDelta;
            if (this.flash <= 0) {
                this.displayHealth = newHealth;
            }
        }
        if (((EntityLivingBase)this.host).func_70644_a(MobEffects.field_76428_l)) {
            this.regenCounter += updateDelta * 2;
            if (this.regenCounter >= this.maxHealth + 30) {
                this.regenCounter = 0;
            }
        } else {
            this.regenCounter = -2;
        }
        this.currentHealth = newHealth;
        this.currentUpdateCounter = newUpdateCounter;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        super.render();
    }
}

