/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.endteleporters.block;

import com.markus1002.endteleporters.Config;
import com.markus1002.endteleporters.EndTeleporters;
import com.markus1002.endteleporters.block.EnderFrameEye;
import com.markus1002.endteleporters.block.EnderFrameTileEntity;
import com.markus1002.endteleporters.util.ModSoundEvents;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnderFrameBlock
extends ContainerBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final EnumProperty<EnderFrameEye> ENDER_FRAME_EYE = EnumProperty.func_177709_a((String)"eye", EnderFrameEye.class);
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final AxisAlignedBB TELEPORT_AABB = new AxisAlignedBB(-1.5, -1.5, -1.5, 2.5, 2.5, 2.5);

    public EnderFrameBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(ENDER_FRAME_EYE, (Comparable)((Object)EnderFrameEye.NONE))).func_206870_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_149750_m(BlockState state) {
        return state.func_177229_b(ENDER_FRAME_EYE) != EnderFrameEye.NONE && (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? super.func_149750_m(state) : 0;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (state.func_177229_b(ENDER_FRAME_EYE) != EnderFrameEye.NONE) {
            if (itemstack.func_77973_b() == Items.field_151079_bi) {
                if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
                    boolean flag = false;
                    int range = this.getRange(worldIn, pos);
                    block0: for (int k = 1; k <= range; ++k) {
                        for (int i = -3; i <= 3; ++i) {
                            for (int j = -3; j <= 3; ++j) {
                                BlockPos blockpos = state.func_177229_b(ENDER_FRAME_EYE) == EnderFrameEye.UP ? pos.func_177982_a(i, k, j) : (state.func_177229_b(ENDER_FRAME_EYE) == EnderFrameEye.DOWN ? pos.func_177982_a(i, -k, j) : (state.func_177229_b(ENDER_FRAME_EYE) == EnderFrameEye.NORTH ? pos.func_177982_a(i, j, -k) : (state.func_177229_b(ENDER_FRAME_EYE) == EnderFrameEye.SOUTH ? pos.func_177982_a(i, j, k) : (state.func_177229_b(ENDER_FRAME_EYE) == EnderFrameEye.WEST ? pos.func_177982_a(-k, j, i) : pos.func_177982_a(k, j, i)))));
                                BlockState blockstate = worldIn.func_180495_p(blockpos);
                                if (blockstate.func_177230_c() != EndTeleporters.ENDER_FRAME || !((Boolean)blockstate.func_177229_b((IProperty)ACTIVE)).booleanValue()) continue;
                                this.teleportEntitiesTo(worldIn, pos, blockpos, player, itemstack);
                                flag = true;
                                break block0;
                            }
                        }
                    }
                    if (!flag && !worldIn.field_72995_K) {
                        this.sendStatusMessage((LivingEntity)player, new TranslationTextComponent("block.endteleporters.ender_frame.no_teleporter", new Object[]{range}));
                        worldIn.func_184133_a((PlayerEntity)null, pos, ModSoundEvents.BLOCK_ENDER_FRAME_TELEPORT_FAIL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    return true;
                }
                if (!worldIn.field_72995_K) {
                    this.sendStatusMessage((LivingEntity)player, new TranslationTextComponent("block.endteleporters.ender_frame.not_active", new Object[0]));
                    worldIn.func_184133_a((PlayerEntity)null, pos, ModSoundEvents.BLOCK_ENDER_FRAME_TELEPORT_FAIL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            if (player.func_175142_cm()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(ENDER_FRAME_EYE, (Comparable)((Object)EnderFrameEye.NONE)), 2);
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!worldIn.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                    double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                    double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.3;
                    double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                    ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, new ItemStack((IItemProvider)Items.field_151061_bv));
                    itementity.func_174869_p();
                    worldIn.func_217376_c((Entity)itementity);
                }
                return true;
            }
        } else {
            if (itemstack.func_77973_b() == Items.field_151061_bv && player.func_175142_cm()) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(ENDER_FRAME_EYE, (Comparable)((Object)this.getEyeState(hit.func_216354_b()))));
                    worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                }
                return true;
            }
            if (itemstack.func_77973_b() == Items.field_151079_bi) {
                if (!worldIn.field_72995_K) {
                    this.sendStatusMessage((LivingEntity)player, new TranslationTextComponent("block.endteleporters.ender_frame.no_eye", new Object[0]));
                    worldIn.func_184133_a((PlayerEntity)null, pos, ModSoundEvents.BLOCK_ENDER_FRAME_TELEPORT_FAIL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    private void sendStatusMessage(LivingEntity livingentity, TranslationTextComponent translationTextComponent) {
        if (livingentity != null && livingentity instanceof PlayerEntity) {
            ((PlayerEntity)livingentity).func_146105_b((ITextComponent)translationTextComponent, true);
        }
    }

    private EnderFrameEye getEyeState(Direction direction) {
        return direction == Direction.UP ? EnderFrameEye.UP : (direction == Direction.DOWN ? EnderFrameEye.DOWN : (direction == Direction.NORTH ? EnderFrameEye.NORTH : (direction == Direction.SOUTH ? EnderFrameEye.SOUTH : (direction == Direction.WEST ? EnderFrameEye.WEST : EnderFrameEye.EAST))));
    }

    private int getRange(World worldIn, BlockPos pos) {
        int range = 0;
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2 && range < (Integer)Config.MAX_TELEPORTER_RANGE.get(); ++z) {
                    BlockState blockstate = worldIn.func_180495_p(pos.func_177982_a(x, y, z));
                    Block block = blockstate.func_177230_c();
                    String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString();
                    if (!((List)Config.TELEPORTER_BLOCKS.get()).contains(name)) continue;
                    range += ((Integer)Config.RANGE_PER_BLOCK.get()).intValue();
                }
            }
        }
        return range;
    }

    private void teleportEntitiesTo(World worldIn, BlockPos pos, BlockPos targetpos, PlayerEntity player, ItemStack itemstack) {
        AxisAlignedBB axisalignedbb = TELEPORT_AABB.func_186670_a(pos);
        List list = worldIn.func_72839_b((Entity)null, axisalignedbb);
        if (!list.isEmpty()) {
            boolean flag = false;
            for (Entity entity : list) {
                String name = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.func_200600_R()).toString();
                if (((List)Config.TELEPORTABLE_ENTITIES_BLACKLIST.get()).contains(name) || !(entity.func_174813_aQ().field_72340_a >= axisalignedbb.field_72340_a) || !(entity.func_174813_aQ().field_72338_b >= axisalignedbb.field_72338_b) || !(entity.func_174813_aQ().field_72339_c >= axisalignedbb.field_72339_c) || !(entity.func_174813_aQ().field_72336_d <= axisalignedbb.field_72336_d) || !(entity.func_174813_aQ().field_72337_e <= axisalignedbb.field_72337_e) || !(entity.func_174813_aQ().field_72334_f <= axisalignedbb.field_72334_f)) continue;
                double d0 = targetpos.func_177958_n() - pos.func_177958_n();
                double d1 = targetpos.func_177956_o() - pos.func_177956_o();
                double d2 = targetpos.func_177952_p() - pos.func_177952_p();
                worldIn.func_184148_a((PlayerEntity)null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, ModSoundEvents.BLOCK_ENDER_FRAME_TELEPORT, entity.func_184176_by(), 1.0f, 1.0f);
                entity.func_70634_a(entity.field_70165_t + d0, entity.field_70163_u + d1, entity.field_70161_v + d2);
                worldIn.func_184148_a((PlayerEntity)null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSoundEvents.BLOCK_ENDER_FRAME_TELEPORT, entity.func_184176_by(), 1.0f, 1.0f);
                flag = true;
            }
            if (flag && !player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (stateIn.func_177229_b(ENDER_FRAME_EYE) != EnderFrameEye.NONE && ((Boolean)stateIn.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            for (int i = 0; i < 3; ++i) {
                int j = rand.nextInt(2) * 2 - 1;
                int k = rand.nextInt(2) * 2 - 1;
                double d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                double d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)k;
                double d3 = rand.nextFloat() * (float)j;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
                double d5 = rand.nextFloat() * (float)k;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ACTIVE, ENDER_FRAME_EYE});
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.IGNORE;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new EnderFrameTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

