/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.endteleporters.block;

import com.markus1002.endteleporters.block.EndTeleportersBlocks;
import com.markus1002.endteleporters.proxy.EndTeleportersConfig;
import com.markus1002.endteleporters.sound.EndTeleportersSoundEvents;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnderFrame
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool EYE = PropertyBool.func_177716_a((String)"eye");
    protected static final AxisAlignedBB ENDER_FRAME_AABB = new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125);

    protected BlockEnderFrame() {
        super(Material.field_151576_e, MapColor.field_151660_b);
        this.func_149672_a(SoundType.field_185853_f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149715_a(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)EYE, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ENDER_FRAME_AABB;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.field_71075_bZ.field_75099_e) {
            return false;
        }
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (!((Boolean)state.func_177229_b((IProperty)EYE)).booleanValue()) {
            if (itemstack.func_190926_b()) {
                return false;
            }
            Item item = itemstack.func_77973_b();
            if (item == Items.field_151061_bv) {
                if (!worldIn.field_72995_K) {
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)playerIn)).func_177226_a((IProperty)EYE, (Comparable)Boolean.valueOf(true)), 3);
                }
                return true;
            }
            if (item == Items.field_151079_bi) {
                if (!worldIn.field_72995_K) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.ender_frame.noEye", new Object[0]), true);
                }
                return true;
            }
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151079_bi) {
            if (this.isStructureFinished(state, worldIn, pos)) {
                boolean booleanToReturn = false;
                booleanToReturn = this.teleportUser(state, worldIn, pos, worldIn.field_73012_v, playerIn, itemstack);
                if (!booleanToReturn) {
                    worldIn.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, EndTeleportersSoundEvents.BLOCK_ENDER_FRAME_TELEPORT_FAIL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    boolean endBoolean = false;
                    int range = this.checkRange(worldIn, pos);
                    if (!worldIn.field_72995_K) {
                        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.ender_frame.noTeleporter", new Object[]{range}), true);
                    }
                }
            } else if (!worldIn.field_72995_K) {
                worldIn.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, EndTeleportersSoundEvents.BLOCK_ENDER_FRAME_TELEPORT_FAIL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.ender_frame.notFinished", new Object[0]), true);
            }
        } else {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)EYE, (Comparable)Boolean.valueOf(false)), 3);
            if (!worldIn.field_72995_K) {
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, new ItemStack(Items.field_151061_bv));
                    entityitem.func_174869_p();
                    worldIn.func_72838_d((Entity)entityitem);
                }
            }
        }
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (((Boolean)state.func_177229_b((IProperty)EYE)).booleanValue()) {
            drops.add((Object)new ItemStack(Items.field_151061_bv));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.isStructureFinished(stateIn, worldIn, pos) && ((Boolean)stateIn.func_177229_b((IProperty)EYE)).booleanValue()) {
            for (int i = 0; i < 3; ++i) {
                int j = rand.nextInt(2) * 2 - 1;
                int k = rand.nextInt(2) * 2 - 1;
                double d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                double d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)k;
                double d3 = rand.nextFloat() * (float)j;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
                double d5 = rand.nextFloat() * (float)k;
                worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)).func_177226_a((IProperty)EYE, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)EYE, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)EYE)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, EYE});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isStructureFinished(IBlockState stateIn, World worldIn, BlockPos pos) {
        IBlockState blockstate;
        int z;
        IBlockState blockstate2;
        BlockPos blockpos;
        int z2;
        int y;
        int x;
        boolean booleanToReturn = true;
        int purpurBlocks = 0;
        int fullBlocks1 = 0;
        int fullBlocks2 = 0;
        int airBlocks = 0;
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 9; ++y) {
                for (z2 = 0; z2 < 9; ++z2) {
                    blockpos = new BlockPos(pos.func_177958_n() - 4 + x, pos.func_177956_o() - 4 + y, pos.func_177952_p() - 4 + z2);
                    blockstate2 = worldIn.func_180495_p(blockpos);
                    if (blockpos.func_177958_n() == pos.func_177958_n() || blockpos.func_177956_o() == pos.func_177956_o() || blockpos.func_177952_p() == pos.func_177952_p() || blockstate2.func_177230_c() != EndTeleportersBlocks.ENDER_FRAME) continue;
                    booleanToReturn = false;
                }
            }
        }
        for (x = 0; x < 7; ++x) {
            for (y = 0; y < 7; ++y) {
                for (z2 = 0; z2 < 7; ++z2) {
                    blockpos = new BlockPos(pos.func_177958_n() - 3 + x, pos.func_177956_o() - 3 + y, pos.func_177952_p() - 3 + z2);
                    blockstate2 = worldIn.func_180495_p(blockpos);
                    List<String> teleporterBlocks = Arrays.asList(EndTeleportersConfig.getTeleporterBlocks());
                    if (!teleporterBlocks.contains(blockstate2.func_177230_c().getRegistryName().toString())) continue;
                    ++purpurBlocks;
                }
            }
        }
        for (x = 0; x < 3; ++x) {
            for (z = 0; z < 3; ++z) {
                BlockPos blockpos2 = new BlockPos(pos.func_177958_n() - 1 + x, pos.func_177956_o() - 2, pos.func_177952_p() - 1 + z);
                blockstate = worldIn.func_180495_p(blockpos2);
                if (!blockstate.func_185917_h()) continue;
                ++fullBlocks1;
            }
        }
        for (x = 0; x < 3; ++x) {
            for (z = 0; z < 3; ++z) {
                BlockPos blockpos3 = new BlockPos(pos.func_177958_n() - 1 + x, pos.func_177956_o() - 3, pos.func_177952_p() - 1 + z);
                blockstate = worldIn.func_180495_p(blockpos3);
                if (!blockstate.func_185917_h()) continue;
                ++fullBlocks2;
            }
        }
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 3; ++y) {
                for (int z3 = 0; z3 < 3; ++z3) {
                    blockpos = new BlockPos(pos.func_177958_n() - 1 + x, pos.func_177956_o() - 1 + y, pos.func_177952_p() - 1 + z3);
                    blockstate2 = worldIn.func_180495_p(blockpos);
                    if (blockstate2.func_185904_a() != Material.field_151579_a) continue;
                    ++airBlocks;
                }
            }
        }
        if (airBlocks >= 26) {
            if (fullBlocks1 >= 9 || fullBlocks2 >= 9) {
                if (purpurBlocks >= 9) {
                    return booleanToReturn;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public int checkRange(World worldIn, BlockPos pos) {
        int range = 0;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 7; ++y) {
                for (int z = 0; z < 7; ++z) {
                    List<String> teleporterBlocks;
                    BlockPos blockpos = new BlockPos(pos.func_177958_n() - 3 + x, pos.func_177956_o() - 3 + y, pos.func_177952_p() - 3 + z);
                    IBlockState blockstate = worldIn.func_180495_p(blockpos);
                    if (range >= EndTeleportersConfig.getMaxRange() || !(teleporterBlocks = Arrays.asList(EndTeleportersConfig.getTeleporterBlocks())).contains(blockstate.func_177230_c().getRegistryName().toString())) continue;
                    range += EndTeleportersConfig.getRangePerBlock();
                }
            }
        }
        return range;
    }

    public boolean teleportUser(IBlockState stateIn, World worldIn, BlockPos pos, Random rand, EntityPlayer playerIn, ItemStack itemstack) {
        boolean endBoolean;
        block18: {
            int range;
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                endBoolean = false;
                                if (!((Boolean)stateIn.func_177229_b((IProperty)EYE)).booleanValue()) break block18;
                                range = this.checkRange(worldIn, pos);
                                if (stateIn.func_177229_b((IProperty)FACING) != EnumFacing.UP) break block19;
                                boolean continueSearching = true;
                                for (int i = 1; continueSearching && i < range && pos.func_177956_o() + i <= 255; ++i) {
                                    for (int x = 0; continueSearching && x < 6; ++x) {
                                        for (int z = 0; continueSearching && z < 6; ++z) {
                                            BlockPos blockpos = new BlockPos(pos.func_177958_n() - 3 + x, pos.func_177956_o() + i, pos.func_177952_p() - 3 + z);
                                            IBlockState blockstate = worldIn.func_180495_p(blockpos);
                                            if (blockstate.func_177230_c() != EndTeleportersBlocks.ENDER_FRAME || !this.isStructureFinished(blockstate, worldIn, blockpos)) continue;
                                            this.teleportUserToLocation(worldIn, blockpos, rand, playerIn, itemstack);
                                            continueSearching = false;
                                            endBoolean = true;
                                        }
                                    }
                                }
                                break block18;
                            }
                            if (stateIn.func_177229_b((IProperty)FACING) != EnumFacing.DOWN) break block20;
                            boolean continueSearching = true;
                            for (int i = 1; continueSearching && i < range && pos.func_177956_o() - i >= 0; ++i) {
                                for (int x = 0; continueSearching && x < 6; ++x) {
                                    for (int z = 0; continueSearching && z < 6; ++z) {
                                        BlockPos blockpos = new BlockPos(pos.func_177958_n() - 3 + x, pos.func_177956_o() - i, pos.func_177952_p() - 3 + z);
                                        IBlockState blockstate = worldIn.func_180495_p(blockpos);
                                        if (blockstate.func_177230_c() != EndTeleportersBlocks.ENDER_FRAME || !this.isStructureFinished(blockstate, worldIn, blockpos)) continue;
                                        this.teleportUserToLocation(worldIn, blockpos, rand, playerIn, itemstack);
                                        continueSearching = false;
                                        endBoolean = true;
                                    }
                                }
                            }
                            break block18;
                        }
                        if (stateIn.func_177229_b((IProperty)FACING) != EnumFacing.NORTH) break block21;
                        boolean continueSearching = true;
                        for (int i = 1; continueSearching && i < range; ++i) {
                            for (int x = 0; continueSearching && x < 6; ++x) {
                                for (int y = 0; continueSearching && y < 6; ++y) {
                                    BlockPos blockpos = new BlockPos(pos.func_177958_n() - 3 + x, pos.func_177956_o() - 3 + y, pos.func_177952_p() - i);
                                    IBlockState blockstate = worldIn.func_180495_p(blockpos);
                                    if (blockstate.func_177230_c() != EndTeleportersBlocks.ENDER_FRAME || !this.isStructureFinished(blockstate, worldIn, blockpos)) continue;
                                    this.teleportUserToLocation(worldIn, blockpos, rand, playerIn, itemstack);
                                    continueSearching = false;
                                    endBoolean = true;
                                }
                            }
                        }
                        break block18;
                    }
                    if (stateIn.func_177229_b((IProperty)FACING) != EnumFacing.SOUTH) break block22;
                    boolean continueSearching = true;
                    for (int i = 1; continueSearching && i < range; ++i) {
                        for (int x = 0; continueSearching && x < 6; ++x) {
                            for (int y = 0; continueSearching && y < 6; ++y) {
                                BlockPos blockpos = new BlockPos(pos.func_177958_n() - 3 + x, pos.func_177956_o() - 3 + y, pos.func_177952_p() + i);
                                IBlockState blockstate = worldIn.func_180495_p(blockpos);
                                if (blockstate.func_177230_c() != EndTeleportersBlocks.ENDER_FRAME || !this.isStructureFinished(blockstate, worldIn, blockpos)) continue;
                                this.teleportUserToLocation(worldIn, blockpos, rand, playerIn, itemstack);
                                continueSearching = false;
                                endBoolean = true;
                            }
                        }
                    }
                    break block18;
                }
                if (stateIn.func_177229_b((IProperty)FACING) != EnumFacing.EAST) break block23;
                boolean continueSearching = true;
                for (int i = 1; continueSearching && i < range; ++i) {
                    for (int z = 0; continueSearching && z < 6; ++z) {
                        for (int y = 0; continueSearching && y < 6; ++y) {
                            BlockPos blockpos = new BlockPos(pos.func_177958_n() + i, pos.func_177956_o() - 3 + y, pos.func_177952_p() - 3 + z);
                            IBlockState blockstate = worldIn.func_180495_p(blockpos);
                            if (blockstate.func_177230_c() != EndTeleportersBlocks.ENDER_FRAME || !this.isStructureFinished(blockstate, worldIn, blockpos)) continue;
                            this.teleportUserToLocation(worldIn, blockpos, rand, playerIn, itemstack);
                            continueSearching = false;
                            endBoolean = true;
                        }
                    }
                }
                break block18;
            }
            if (stateIn.func_177229_b((IProperty)FACING) != EnumFacing.WEST) break block18;
            boolean continueSearching = true;
            for (int i = 1; continueSearching && i < range; ++i) {
                for (int z = 0; continueSearching && z < 6; ++z) {
                    for (int y = 0; continueSearching && y < 6; ++y) {
                        BlockPos blockpos = new BlockPos(pos.func_177958_n() - i, pos.func_177956_o() - 3 + y, pos.func_177952_p() - 3 + z);
                        IBlockState blockstate = worldIn.func_180495_p(blockpos);
                        if (blockstate.func_177230_c() != EndTeleportersBlocks.ENDER_FRAME || !this.isStructureFinished(blockstate, worldIn, blockpos)) continue;
                        this.teleportUserToLocation(worldIn, blockpos, rand, playerIn, itemstack);
                        continueSearching = false;
                        endBoolean = true;
                    }
                }
            }
        }
        return endBoolean;
    }

    public void teleportUserToLocation(World worldIn, BlockPos pos, Random rand, EntityPlayer playerIn, ItemStack itemstack) {
        if (!worldIn.field_72995_K) {
            BlockPos teleportpos;
            IBlockState teleportblockstate;
            int x = -1;
            int z = -1;
            if (rand.nextInt(2) == 0) {
                x = 1;
            }
            if (rand.nextInt(2) == 0) {
                z = 1;
            }
            if (itemstack.func_77973_b() == Items.field_151079_bi && !playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if ((teleportblockstate = worldIn.func_180495_p(teleportpos = new BlockPos((double)(pos.func_177958_n() + x) + 0.5, (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() + z) + 0.5))).func_185917_h()) {
                worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, EndTeleportersSoundEvents.BLOCK_ENDER_FRAME_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                playerIn.func_70634_a((double)(pos.func_177958_n() + x) + 0.5, (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() + z) + 0.5);
                worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, EndTeleportersSoundEvents.BLOCK_ENDER_FRAME_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.0f);
            } else {
                worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, EndTeleportersSoundEvents.BLOCK_ENDER_FRAME_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                playerIn.func_70634_a((double)(pos.func_177958_n() + x) + 0.5, (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() + z) + 0.5);
                worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, EndTeleportersSoundEvents.BLOCK_ENDER_FRAME_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

