/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.endteleporters.proxy;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EndTeleportersConfig {
    private static Configuration config;
    public static int maxRange;
    public static int rangePerBlock;
    public static String[] teleporterBlocks;

    public static void loadConfig(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        EndTeleportersConfig.reloadConfig();
        MinecraftForge.EVENT_BUS.register((Object)new EndTeleportersConfig());
    }

    private static void reloadConfig() {
        maxRange = config.get("Ender Frame", "Teleporter max range", 3000, "The max distance (in blocks) that can be teleported using a teleporter.").getInt();
        rangePerBlock = config.get("Ender Frame", "Teleporter range per block", 40, "The amount of teleportation distance (in blocks) added per block in a teleporter.").getInt();
        teleporterBlocks = config.get("Ender Frame", "Teleporter blocks", new String[]{"minecraft:purpur_block", "minecraft:purpur_pillar", "minecraft:purpur_double_slab", "quark:duskbound_block", "quark:duskbound_lantern", "quark:duskbound_block_slab_double"}, "The blocks that can be used to build a teleporter and extend it's range.").getStringList();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("endteleporters")) {
            EndTeleportersConfig.reloadConfig();
        }
    }

    public static int getMaxRange() {
        return maxRange;
    }

    public static int getRangePerBlock() {
        return rangePerBlock;
    }

    public static String[] getTeleporterBlocks() {
        return teleporterBlocks;
    }
}

