/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.endteleporters;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<String>> teleporterBlocks;
        public final ForgeConfigSpec.ConfigValue<List<String>> teleportableEntitiesBlacklist;
        public final ForgeConfigSpec.ConfigValue<Integer> maxTeleporterRange;
        public final ForgeConfigSpec.ConfigValue<Integer> minTeleporterBlocks;
        public final ForgeConfigSpec.ConfigValue<Integer> rangePerBlock;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("common");
            this.teleporterBlocks = builder.comment("Blocks that can be used to construct a teleporter and increase its range.").define("Teleporter Blocks", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:purpur_block", "minecraft:purpur_pillar", "quark:duskbound_block", "quark:duskbound_lantern"}));
            this.teleportableEntitiesBlacklist = builder.comment("Entities that can not be teleported using a teleporter. By default used for block-like entities and entities from the End.").define("Teleportable Entities Blacklist", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:armor_stand", "minecraft:enderman", "minecraft:wither", "minecraft:shulker", "minecraft:endermite", "endergetic:poise_cluster", "endergetic:boof_block", "endergetic:puff_bug"}));
            this.maxTeleporterRange = builder.comment("The maximum distance (in blocks) that can be traveled using a teleporter.").define("Max Teleporter Range", (Object)3000);
            this.minTeleporterBlocks = builder.comment("The minimum amount of purpur blocks required to activate a teleporter.").define("Min Teleporter Blocks", (Object)9);
            this.rangePerBlock = builder.comment("The amount of range added per purpur block.").define("Range Per Block", (Object)40);
            builder.pop();
        }
    }
}

