/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.renderer;

import net.minecraft.block.properties.IProperty;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import rustic.client.models.ModelCabinet;
import rustic.client.models.ModelCabinetDouble;
import rustic.common.blocks.BlockCabinet;
import rustic.common.tileentity.TileEntityCabinet;

public class CabinetRenderer
extends TileEntitySpecialRenderer<TileEntityCabinet> {
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("rustic:textures/models/cabinet.png");
    private static final ResourceLocation TEXTURE_DOUBLE = new ResourceLocation("rustic:textures/models/cabinet_double.png");
    private final ModelCabinet simpleCabinet = new ModelCabinet(false);
    private final ModelCabinet simpleCabinetM = new ModelCabinet(true);
    private final ModelCabinetDouble doubleCabinet = new ModelCabinetDouble(false);
    private final ModelCabinetDouble doubleCabinetM = new ModelCabinetDouble(true);

    public void renderTileEntityAt(TileEntityCabinet te, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        if (te.func_145830_o() && !((Boolean)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockCabinet.TOP)).booleanValue()) {
            boolean mirror = (Boolean)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockCabinet.MIRROR);
            boolean renderDouble = (Boolean)te.func_145831_w().func_180495_p(te.func_174877_v()).func_185899_b((IBlockAccess)te.func_145831_w(), te.func_174877_v()).func_177229_b((IProperty)BlockCabinet.BOTTOM);
            ModelBase modelcabinet = this.simpleCabinet;
            this.func_147499_a(TEXTURE_NORMAL);
            if (mirror) {
                modelcabinet = this.simpleCabinetM;
            }
            if (renderDouble) {
                modelcabinet = this.doubleCabinet;
                this.func_147499_a(TEXTURE_DOUBLE);
                if (mirror) {
                    modelcabinet = this.doubleCabinetM;
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            if (destroyStage < 0) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            int rotation = 0;
            switch ((EnumFacing)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockCabinet.FACING)) {
                case WEST: {
                    rotation = 90;
                    break;
                }
                case NORTH: {
                    rotation = 180;
                    break;
                }
                case EAST: {
                    rotation = 270;
                    break;
                }
            }
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float f = te.prevLidAngle + (te.lidAngle - te.prevLidAngle) * partialTicks;
            f = 1.0f - f;
            f = 1.0f - f * f * f;
            if (renderDouble) {
                ((ModelCabinetDouble)modelcabinet).setRotation(((ModelCabinetDouble)modelcabinet).door, 0.0f, mirror ? -(f * 1.5707964f) : f * 1.5707964f, 0.0f);
            } else {
                ((ModelCabinet)modelcabinet).setRotation(((ModelCabinet)modelcabinet).door, 0.0f, mirror ? -(f * 1.5707964f) : f * 1.5707964f, 0.0f);
            }
            GlStateManager.func_179109_b((float)0.5f, (float)-0.5f, (float)0.5f);
            if (renderDouble) {
                ((ModelCabinetDouble)modelcabinet).renderAll();
            } else {
                ((ModelCabinet)modelcabinet).renderAll();
            }
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

