/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockBase;

public class BlockChair
extends BlockBase {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB CHAIR_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.125, 0.875);

    public BlockChair(String type) {
        super(Material.field_151575_d, "chair_" + type);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CHAIR_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack stack) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        List chairs = world.func_72872_a(Chair.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
        if (chairs.isEmpty()) {
            Chair chair = new Chair(world, pos);
            world.func_72838_d((Entity)chair);
            player.func_184220_m((Entity)chair);
        }
        return true;
    }

    public static class Chair
    extends Entity {
        public Chair(World world, BlockPos pos) {
            super(world);
            this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.5);
            this.func_70105_a(0.0f, 0.0f);
        }

        public void func_70071_h_() {
            BlockPos pos = this.func_180425_c();
            if (pos != null && !(this.func_130014_f_().func_180495_p(pos).func_177230_c() instanceof BlockChair)) {
                this.func_70106_y();
                return;
            }
            List passengers = this.func_184188_bt();
            if (passengers.isEmpty()) {
                this.func_70106_y();
            }
            for (Entity e : passengers) {
                if (!e.func_70093_af()) continue;
                this.func_70106_y();
            }
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }
}

