/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.inventory;

import com.google.common.base.Objects;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import rustic.common.blocks.BlockCabinet;
import rustic.common.tileentity.TileEntityCabinet;

public class DoubleCabinetItemHandler
extends WeakReference<TileEntityCabinet>
implements IItemHandlerModifiable {
    public static final DoubleCabinetItemHandler NO_ADJACENT_CABINETS_INSTANCE = new DoubleCabinetItemHandler(null, null, false);
    private final boolean mainCabinetIsUpper;
    private final TileEntityCabinet mainCabinet;
    private final int hashCode;

    public DoubleCabinetItemHandler(@Nullable TileEntityCabinet mainCabinet, @Nullable TileEntityCabinet other, boolean mainCabinetIsUpper) {
        super(other);
        this.mainCabinet = mainCabinet;
        this.mainCabinetIsUpper = mainCabinetIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainCabinetIsUpper ? mainCabinet : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainCabinetIsUpper ? mainCabinet : other});
    }

    @Nullable
    public static DoubleCabinetItemHandler get(TileEntityCabinet cabinet) {
        TileEntity otherTE;
        BlockPos blockpos;
        Block block;
        World world = cabinet.func_145831_w();
        BlockPos pos = cabinet.func_174877_v();
        if (world == null || pos == null || !world.func_175667_e(pos)) {
            return null;
        }
        Block blockType = cabinet.func_145838_q();
        if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)BlockCabinet.TOP)).booleanValue()) {
            TileEntity otherTE2;
            BlockPos blockpos2 = pos.func_177977_b();
            Block block2 = world.func_180495_p(blockpos2).func_177230_c();
            if (block2 == blockType && (otherTE2 = world.func_175625_s(blockpos2)) instanceof TileEntityCabinet) {
                TileEntityCabinet otherCabinet = (TileEntityCabinet)otherTE2;
                return new DoubleCabinetItemHandler(cabinet, otherCabinet, true);
            }
        } else if (((Boolean)world.func_180495_p(pos).func_177230_c().func_176221_a(world.func_180495_p(pos), (IBlockAccess)world, pos).func_177229_b((IProperty)BlockCabinet.BOTTOM)).booleanValue() && (block = world.func_180495_p(blockpos = pos.func_177984_a()).func_177230_c()) == blockType && (otherTE = world.func_175625_s(blockpos)) instanceof TileEntityCabinet) {
            TileEntityCabinet otherCabinet = (TileEntityCabinet)otherTE;
            return new DoubleCabinetItemHandler(cabinet, otherCabinet, false);
        }
        return NO_ADJACENT_CABINETS_INSTANCE;
    }

    @Nullable
    public TileEntityCabinet getCabinet(boolean accessingUpper) {
        if (accessingUpper == this.mainCabinetIsUpper) {
            return this.mainCabinet;
        }
        return this.getOtherCabinet();
    }

    @Nullable
    private TileEntityCabinet getOtherCabinet() {
        TileEntityCabinet tileEntityCabinet = (TileEntityCabinet)((Object)this.get());
        return tileEntityCabinet != null && !tileEntityCabinet.func_145837_r() ? tileEntityCabinet : null;
    }

    public int getSlots() {
        return 54;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        boolean accessingUpperCabinet = slot < 27;
        int targetSlot = accessingUpperCabinet ? slot : slot - 27;
        TileEntityCabinet cabinet = this.getCabinet(accessingUpperCabinet);
        return cabinet != null ? cabinet.func_70301_a(targetSlot) : null;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        boolean accessingUpperCabinet = slot < 27;
        int targetSlot = accessingUpperCabinet ? slot : slot - 27;
        TileEntityCabinet cabinet = this.getCabinet(accessingUpperCabinet);
        if (cabinet != null) {
            cabinet.func_70299_a(targetSlot, stack);
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean accessingUpperCabinet = slot < 27;
        int targetSlot = accessingUpperCabinet ? slot : slot - 27;
        TileEntityCabinet cabinet = this.getCabinet(accessingUpperCabinet);
        return cabinet != null ? cabinet.getSingleCabinetHandler().insertItem(targetSlot, stack, simulate) : stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperCabinet = slot < 27;
        int targetSlot = accessingUpperCabinet ? slot : slot - 27;
        TileEntityCabinet cabinet = this.getCabinet(accessingUpperCabinet);
        return cabinet != null ? cabinet.getSingleCabinetHandler().extractItem(targetSlot, amount, simulate) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleCabinetItemHandler that = (DoubleCabinetItemHandler)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        TileEntityCabinet otherCabinet = this.getOtherCabinet();
        if (this.mainCabinetIsUpper == that.mainCabinetIsUpper) {
            return Objects.equal((Object)((Object)this.mainCabinet), (Object)((Object)that.mainCabinet)) && Objects.equal((Object)((Object)otherCabinet), (Object)((Object)that.getOtherCabinet()));
        }
        return Objects.equal((Object)((Object)this.mainCabinet), (Object)((Object)that.getOtherCabinet())) && Objects.equal((Object)((Object)otherCabinet), (Object)((Object)that.mainCabinet));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CABINETS_INSTANCE) {
            return false;
        }
        TileEntityCabinet tileEntityCabinet = (TileEntityCabinet)((Object)this.get());
        return tileEntityCabinet == null || tileEntityCabinet.func_145837_r();
    }
}

