/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import rustic.common.Config;
import rustic.common.items.ModItems;

public class TileEntityApiary
extends TileEntity
implements ITickable {
    private ItemStackHandler itemStackHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TileEntityApiary.this.func_70296_d();
        }
    };
    private int reproductionTime = 1200;
    private int reproductionTimer = 0;
    private int productionTime = 600;
    private int productionTimer = 0;
    private Random random = new Random();

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.func_145843_s();
        if (this.itemStackHandler != null && !world.field_72995_K) {
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                if (this.itemStackHandler.getStackInSlot(i) == null) continue;
                state.func_177230_c();
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.itemStackHandler.getStackInSlot(i));
            }
        }
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        int numBees = 0;
        if (this.itemStackHandler.getStackInSlot(0) != null && this.itemStackHandler.getStackInSlot(0).func_77973_b().equals((Object)ModItems.BEE)) {
            numBees = this.itemStackHandler.getStackInSlot((int)0).field_77994_a;
        }
        int numHoneycomb = 0;
        if (this.itemStackHandler.getStackInSlot(1) != null && this.itemStackHandler.getStackInSlot(1).func_77973_b().equals((Object)ModItems.HONEYCOMB)) {
            numHoneycomb = this.itemStackHandler.getStackInSlot((int)1).field_77994_a;
        }
        if (numBees > 0 && !this.func_145831_w().field_72995_K) {
            this.reproductionTime = (int)(Config.BEE_REPRODUCTION_MULTIPLIER * (float)(800 / (numBees / 20 + 1)));
            this.productionTime = (int)(Config.BEE_HONEYCOMB_MULTIPLIER * (float)(400 / (numBees / 20 + 1)));
            ++this.reproductionTimer;
            ++this.productionTimer;
            if (this.reproductionTimer >= this.reproductionTime) {
                this.reproductionTimer = 0;
                if (numBees < 64) {
                    ++this.itemStackHandler.getStackInSlot((int)0).field_77994_a;
                }
            }
            if (this.productionTimer >= this.productionTime) {
                this.productionTimer = 0;
                if (numHoneycomb == 0) {
                    this.itemStackHandler.setStackInSlot(1, new ItemStack((Item)ModItems.HONEYCOMB, 1));
                } else if (numHoneycomb < 64) {
                    ++this.itemStackHandler.getStackInSlot((int)1).field_77994_a;
                }
            }
            if (this.random.nextInt((int)(1028.0f / ((float)numBees * Config.BEE_GROWTH_MULTIPLIER))) == 1) {
                int randX = this.random.nextInt(9) - 4;
                int randZ = this.random.nextInt(9) - 4;
                for (int i = 0; i < 3; ++i) {
                    int x = this.func_174877_v().func_177958_n();
                    int y = this.func_174877_v().func_177956_o();
                    int z = this.func_174877_v().func_177952_p();
                    BlockPos pos = new BlockPos(x + randX, y + 1 - i, z + randZ);
                    Block block = this.func_145831_w().func_180495_p(new BlockPos(x + randX, y + 1 - i, z + randZ)).func_177230_c();
                    if (!(block instanceof IGrowable)) continue;
                    if (!((IGrowable)block).func_176473_a(this.func_145831_w(), pos, this.func_145831_w().func_180495_p(pos), this.func_145831_w().field_72995_K)) break;
                    ((IGrowable)block).func_176474_b(this.func_145831_w(), this.random, pos, this.func_145831_w().func_180495_p(pos));
                    break;
                }
            }
            this.func_70296_d();
        }
    }
}

