/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import rustic.common.blocks.BlockCabinet;
import rustic.common.inventory.DoubleCabinetItemHandler;
import rustic.common.tileentity.ContainerCabinet;
import rustic.common.tileentity.ContainerCabinetDouble;

public class TileEntityCabinet
extends TileEntityLockable
implements ITickable {
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    public int numPlayersUsing = 0;
    private int ticksSinceSync = 0;
    private ItemStackHandler itemStackHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileEntityCabinet.this.func_70296_d();
        }
    };
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    public DoubleCabinetItemHandler doubleCabinetHandler;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_176221_a(this.field_145850_b.func_180495_p(this.field_174879_c), (IBlockAccess)this.field_145850_b, this.field_174879_c).func_177229_b((IProperty)BlockCabinet.BOTTOM)).booleanValue()) {
            return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 2.0, (double)this.field_174879_c.func_177952_p() + 1.0);
        }
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 1.0);
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                TileEntityCabinet tec;
                if (entityplayer.field_71070_bA instanceof ContainerCabinet) {
                    tec = ((ContainerCabinet)entityplayer.field_71070_bA).getTile();
                    if (!((Object)((Object)tec)).equals((Object)this)) continue;
                    ++this.numPlayersUsing;
                    continue;
                }
                if (!(entityplayer.field_71070_bA instanceof ContainerCabinetDouble) || !((Object)((Object)(tec = ((ContainerCabinetDouble)entityplayer.field_71070_bA).getTileBottom()))).equals((Object)this)) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        float f1 = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float f3 = 0.5f;
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockCabinet) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.doubleCabinetHandler == null || this.doubleCabinetHandler.needsRefresh()) {
                this.doubleCabinetHandler = DoubleCabinetItemHandler.get(this);
            }
            if (this.doubleCabinetHandler != null && this.doubleCabinetHandler != DoubleCabinetItemHandler.NO_ADJACENT_CABINETS_INSTANCE) {
                return (T)this.doubleCabinetHandler;
            }
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getSingleCabinetHandler() {
        return this.itemStackHandler;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.doubleCabinetHandler = null;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.func_145843_s();
        if (this.itemStackHandler != null && !world.field_72995_K) {
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                if (this.itemStackHandler.getStackInSlot(i) == null) continue;
                state.func_177230_c();
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.itemStackHandler.getStackInSlot(i));
            }
        }
        world.func_175690_a(pos, null);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public int func_70302_i_() {
        return this.itemStackHandler.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (this.itemStackHandler.getStackInSlot(i) == null) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.itemStackHandler.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.itemStackHandler.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(index);
        this.itemStackHandler.setStackInSlot(index, null);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.itemStackHandler.setStackInSlot(index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            this.itemStackHandler.setStackInSlot(i, null);
        }
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        if (((Boolean)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCabinet.TOP)).booleanValue()) {
            return new ContainerCabinetDouble((IInventory)playerInventory, this, (TileEntityCabinet)this.func_145831_w().func_175625_s(this.field_174879_c.func_177977_b()), playerIn);
        }
        if (((Boolean)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCabinet.BOTTOM)).booleanValue()) {
            return new ContainerCabinetDouble((IInventory)playerInventory, (TileEntityCabinet)this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a()), this, playerIn);
        }
        return new ContainerCabinet((IInventory)playerInventory, this, playerIn);
    }

    public String func_174875_k() {
        return "rustic:cabinet";
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }
}

