/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.gui;

import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import rustic.client.util.FluidClientUtil;
import rustic.common.tileentity.ContainerCondenser;
import rustic.common.tileentity.TileEntityCondenser;

public class GuiCondenser
extends GuiContainer {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 166;
    private static final ResourceLocation background = new ResourceLocation("rustic", "textures/gui/condenser.png");
    TileEntityCondenser te;
    InventoryPlayer playerInv;

    public GuiCondenser(ContainerCondenser container, InventoryPlayer playerInv) {
        super((Container)container);
        this.playerInv = playerInv;
        this.te = container.getTile();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.te.func_145748_c_().func_150260_c(), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInv.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (this.func_146978_c(133, 27, 16, 32, mouseX, mouseY)) {
            FluidStack fluid = null;
            if (this.te.getFluid() != null && this.te.getAmount() > 0) {
                fluid = new FluidStack(this.te.getFluid(), this.te.getAmount());
            }
            this.drawFluidTooltip(fluid, this.te.getCapacity(), mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.te.getAmount() > 0) {
            FluidClientUtil.drawGuiLiquid(new FluidStack(this.te.getFluid(), this.te.getAmount()), this.te.getCapacity(), this.field_147003_i + 133, this.field_147009_r + 27, 16, 32, background);
        }
        if (this.te.isBurning()) {
            int k = this.getBurnLeftScaled(13);
            this.func_73729_b(this.field_147003_i + 67, this.field_147009_r + 46 + 12 - k, 176, 12 - k, 14, k + 1);
        }
        int l = this.getBrewProgressScaled(50);
        this.func_73729_b(this.field_147003_i + 44, this.field_147009_r + 29, 176, 14, l, 28);
    }

    private int getBrewProgressScaled(int pixels) {
        int i = this.te.brewTime;
        int j = this.te.totalBrewTime;
        return j != 0 && i != 0 ? i * pixels / j + 1 : 0;
    }

    private int getBurnLeftScaled(int pixels) {
        int i = this.te.currentItemBurnTime;
        if (i == 0) {
            i = 200;
        }
        return this.te.condenserBurnTime * pixels / i;
    }

    protected void drawFluidTooltip(FluidStack fluid, int capacity, int x, int y) {
        ArrayList<String> lines = new ArrayList<String>();
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            lines.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.rustic.empty", (Object[])new Object[0]));
            lines.add(TextFormatting.GRAY + "" + 0 + "/" + capacity);
        } else {
            lines.add(fluid.getFluid().getRarity((FluidStack)fluid).field_77937_e + fluid.getLocalizedName());
            lines.add(TextFormatting.GRAY + "" + fluid.amount + "/" + capacity);
        }
        this.func_146283_a(lines, x - this.field_147003_i, y - this.field_147009_r);
    }
}

