/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.models;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidBottleModel
implements IModel,
IModelCustomData,
IRetexturableModel {
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(new ResourceLocation("rustic", "fluid_bottle"), "inventory");
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL = new FluidBottleModel();
    @Nullable
    private final ResourceLocation liquidLocation = new ResourceLocation("minecraft", "items/potion_overlay");
    @Nullable
    private final ResourceLocation bottleLocation = new ResourceLocation("minecraft", "items/potion_bottle_drinkable");
    @Nullable
    private final Fluid fluid;

    public FluidBottleModel() {
        this.fluid = null;
    }

    public FluidBottleModel(Fluid fluid) {
        this.fluid = fluid;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        ResourceLocation liquid = this.liquidLocation;
        ResourceLocation bottle = this.bottleLocation;
        if (textures.containsKey((Object)"fluid")) {
            liquid = new ResourceLocation((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"bottle")) {
            bottle = new ResourceLocation((String)textures.get((Object)"bottle"));
        }
        return new FluidBottleModel(this.fluid);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        return new FluidBottleModel(fluid);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.liquidLocation != null) {
            builder.add((Object)this.liquidLocation);
        }
        if (this.bottleLocation != null) {
            builder.add((Object)this.bottleLocation);
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = (TRSRTransformation)state.apply(Optional.absent()).or((Object)TRSRTransformation.identity());
        TextureAtlasSprite fluidSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.fluid.getStill());
        }
        if (this.bottleLocation != null) {
            IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)this.bottleLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            TextureAtlasSprite liquid = (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.liquidLocation);
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (EnumFacing)EnumFacing.NORTH, (int)this.fluid.getColor()));
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (EnumFacing)EnumFacing.SOUTH, (int)this.fluid.getColor()));
        }
        return new BakedFluidBottle(this, (ImmutableList<BakedQuad>)builder.build(), fluidSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap());
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private static final class BakedFluidBottle
    implements IPerspectiveAwareModel {
        private final FluidBottleModel parent;
        private final Map<String, IBakedModel> cache;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;
        private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);

        public BakedFluidBottle(FluidBottleModel parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.parent = parent;
            this.transforms = BakedFluidBottle.itemTransforms();
            this.cache = cache;
        }

        public ItemOverrideList func_188617_f() {
            return BakedFluidBottleOverrideHandler.INSTANCE;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransforms() {
            TRSRTransformation thirdperson = BakedFluidBottle.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
            TRSRTransformation firstperson = BakedFluidBottle.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)BakedFluidBottle.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
            builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)BakedFluidBottle.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)BakedFluidBottle.leftify(thirdperson));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstperson);
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)BakedFluidBottle.leftify(firstperson));
            return builder.build();
        }

        private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
            return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
        }

        private static TRSRTransformation leftify(TRSRTransformation transform) {
            return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }
    }

    private static final class BakedFluidBottleOverrideHandler
    extends ItemOverrideList {
        public static final BakedFluidBottleOverrideHandler INSTANCE = new BakedFluidBottleOverrideHandler();

        private BakedFluidBottleOverrideHandler() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            FluidStack fluidStack = null;
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid")) {
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
            }
            if (fluidStack == null) {
                return originalModel;
            }
            BakedFluidBottle model = (BakedFluidBottle)originalModel;
            Fluid fluid = fluidStack.getFluid();
            String name = fluid.getName();
            if (!model.cache.containsKey(name)) {
                IModel parent = model.parent.process((ImmutableMap<String, String>)ImmutableMap.of((Object)"fluid", (Object)name));
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.format, (Function)textureGetter);
                model.cache.put(name, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(name);
        }
    }

    public static enum LoaderFluidBottle implements ICustomModelLoader
    {
        INSTANCE;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("rustic") && modelLocation.func_110623_a().contains("fluid_bottle");
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

